/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.examples;

import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapred.output.DeprecatedOutputFormatWrapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class DeprecatedWrapperWordCount {
    private DeprecatedWrapperWordCount() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("CLASSPATH: " + System.getProperty("CLASSPATH"));
        GenericOptionsParser options = new GenericOptionsParser(args);
        args = options.getRemainingArgs();
        if (args.length != 2) {
            System.err.println("Usage: hadoop jar path/to/this.jar " + DeprecatedWrapperWordCount.class + " <input dir> <output dir>");
            System.exit(1);
        }
        JobConf job = new JobConf(options.getConfiguration());
        job.setJobName("Deprecated Wrapper Word Count");
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setJarByClass(DeprecatedWrapperWordCount.class);
        job.setMapperClass(WordCountMapper.class);
        job.setCombinerClass(WordCountReducer.class);
        job.setReducerClass(WordCountReducer.class);
        job.setInputFormat(DeprecatedInputFormatWrapper.class);
        DeprecatedInputFormatWrapper.setInputFormat(TextInputFormat.class, (JobConf)job);
        job.setOutputFormat(DeprecatedOutputFormatWrapper.class);
        DeprecatedOutputFormatWrapper.setOutputFormat(TextOutputFormat.class, (JobConf)job);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        JobClient.runJob((JobConf)job).waitForCompletion();
    }

    public static class WordCountReducer
    extends MapReduceBase
    implements Reducer<Text, LongWritable, Text, LongWritable> {
        LongWritable longWritable = new LongWritable(0L);

        public void reduce(Text key, Iterator<LongWritable> values, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            long total = 0L;
            while (values.hasNext()) {
                total += values.next().get();
            }
            this.longWritable.set(total);
            collector.collect((Object)key, (Object)this.longWritable);
        }
    }

    public static class WordCountMapper
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, LongWritable> {
        private final LongWritable one = new LongWritable(1L);
        private final Text word = new Text();

        public void map(LongWritable key, Text value, OutputCollector<Text, LongWritable> collector, Reporter reporter) throws IOException {
            String line = value.toString();
            StringTokenizer tokenizer = new StringTokenizer(line);
            while (tokenizer.hasMoreTokens()) {
                this.word.set(tokenizer.nextToken());
                collector.collect((Object)this.word, (Object)this.one);
            }
        }
    }
}

