/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');

    private HadoopUtils() {
    }

    public static Counter getCounter(JobContext ctx, String group, String counter) {
        Counter c;
        if (ctx instanceof TaskInputOutputContext && (c = HadoopCompat.getCounter((TaskInputOutputContext)((TaskInputOutputContext)ctx), (String)group, (String)counter)) != null) {
            return c;
        }
        String name = group + ":" + counter;
        LOG.warn("Using a dummy counter for " + name + " because it does not already exist.");
        return HadoopCompat.newGenericCounter((String)name, (String)name, (long)0L);
    }

    @Deprecated
    public static void setInputFormatClass(Configuration conf, String configKey, Class<?> clazz) {
        HadoopUtils.setClassConf(conf, configKey, clazz);
    }

    public static void setClassConf(Configuration conf, String configKey, Class<?> clazz) {
        String existingClass = conf.get(configKey);
        String className = clazz.getName();
        if (existingClass != null && !existingClass.equals(className)) {
            throw new RuntimeException("Already registered a different thriftClass for " + configKey + ". old: " + existingClass + " new: " + className);
        }
        conf.set(configKey, className);
    }

    public static void writeObjectToConfAsBase64(String key, Object obj, Configuration conf) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        oos.close();
        conf.set(key, new String(Base64.encodeBase64((byte[])baos.toByteArray()), Charsets.UTF_8));
    }

    public static <T> T readObjectFromConfAsBase64(String key, Configuration conf) throws IOException {
        String b64 = conf.get(key);
        if (b64 == null) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((byte[])b64.getBytes(Charsets.UTF_8));
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            return (T)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not read object from config with key " + key, (Throwable)e);
            throw new IOException(e);
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't cast object read from config with key " + key, (Throwable)e);
            throw new IOException(e);
        }
    }

    public static void writeStringListToConfAsJson(String key, List<String> list, Configuration conf) {
        Preconditions.checkNotNull(list);
        conf.set(key, JSONArray.toJSONString(list));
    }

    public static List<String> readStringListFromConfAsJson(String key, Configuration conf) {
        String json = conf.get(key);
        if (json == null) {
            return null;
        }
        return Lists.newArrayList((Iterable)((JSONArray)JSONValue.parse((String)json)));
    }

    public static void writeStringListToConfAsBase64(String key, List<String> list, Configuration conf) {
        Preconditions.checkNotNull(list);
        Iterator<String> iter = list.iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            byte[] bytes = Base64.encodeBase64((byte[])iter.next().getBytes(Charsets.UTF_8), (boolean)false);
            sb.append(new String(bytes, Charsets.UTF_8));
            if (!iter.hasNext()) continue;
            sb.append(',');
        }
        conf.set(key, sb.toString());
    }

    public static List<String> readStringListFromConfAsBase64(String key, Configuration conf) {
        String b64List = conf.get(key);
        if (b64List == null) {
            return null;
        }
        ArrayList strings = Lists.newArrayList();
        for (String b64 : COMMA_SPLITTER.split((CharSequence)b64List)) {
            byte[] bytes = Base64.decodeBase64((byte[])b64.getBytes(Charsets.UTF_8));
            strings.add(new String(bytes, Charsets.UTF_8));
        }
        return strings;
    }
}

