/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UninitializedMessageException;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufConverter<M extends Message>
implements BinaryConverter<M> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufConverter.class);
    private Message defaultInstance;
    private TypeRef<M> typeRef;
    private static final int MAX_WARNINGS = 100;
    private static int numWarningsLogged = 0;

    private static void logWarning(String message, Throwable t) {
        if (numWarningsLogged < 100) {
            LOG.info(message, t);
            ++numWarningsLogged;
        }
    }

    public static <M extends Message> ProtobufConverter<M> newInstance(Class<M> protoClass) {
        return new ProtobufConverter<M>(new TypeRef<M>(protoClass){});
    }

    public static <M extends Message> ProtobufConverter<M> newInstance(TypeRef<M> typeRef) {
        return new ProtobufConverter<M>(typeRef);
    }

    public ProtobufConverter(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public M fromBytes(byte[] messageBuffer) {
        return this.fromBytes(messageBuffer, 0, messageBuffer.length);
    }

    public M fromBytes(byte[] messageBuffer, int offset, int len) {
        try {
            if (this.defaultInstance == null) {
                this.defaultInstance = Protobufs.getMessageBuilder(this.typeRef.getRawClass()).getDefaultInstanceForType();
            }
            return (M)this.defaultInstance.newBuilderForType().mergeFrom(messageBuffer, offset, len).build();
        }
        catch (InvalidProtocolBufferException e) {
            ProtobufConverter.logWarning("Invalid Protobuf exception while building " + this.typeRef.getRawClass().getName(), e);
        }
        catch (UninitializedMessageException ume) {
            ProtobufConverter.logWarning("Uninitialized Message Exception while building " + this.typeRef.getRawClass().getName(), ume);
        }
        return null;
    }

    @Override
    public byte[] toBytes(M message) {
        return message.toByteArray();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        try {
            return this.typeRef.getType().equals(((ProtobufConverter)obj).typeRef.getType());
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

