/*
 * Decompiled with CFR 0.152.
 */
package thrift.test;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class ComparableUnion
extends TUnion<ComparableUnion, _Fields> {
    private static final TStruct STRUCT_DESC = new TStruct("ComparableUnion");
    private static final TField STRING_FIELD_FIELD_DESC = new TField("string_field", 11, 1);
    private static final TField BINARY_FIELD_FIELD_DESC = new TField("binary_field", 11, 2);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ComparableUnion() {
    }

    public ComparableUnion(_Fields setField, Object value) {
        super((TFieldIdEnum)setField, value);
    }

    public ComparableUnion(ComparableUnion other) {
        super((TUnion)other);
    }

    public ComparableUnion deepCopy() {
        return new ComparableUnion(this);
    }

    public static ComparableUnion string_field(String value) {
        ComparableUnion x = new ComparableUnion();
        x.setString_field(value);
        return x;
    }

    public static ComparableUnion binary_field(ByteBuffer value) {
        ComparableUnion x = new ComparableUnion();
        x.setBinary_field(value);
        return x;
    }

    protected void checkType(_Fields setField, Object value) throws ClassCastException {
        switch (setField) {
            case STRING_FIELD: {
                if (value instanceof String) break;
                throw new ClassCastException("Was expecting value of type String for field 'string_field', but got " + value.getClass().getSimpleName());
            }
            case BINARY_FIELD: {
                if (value instanceof ByteBuffer) break;
                throw new ClassCastException("Was expecting value of type ByteBuffer for field 'binary_field', but got " + value.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
            }
        }
    }

    protected Object readValue(TProtocol iprot, TField field) throws TException {
        _Fields setField = _Fields.findByThriftId(field.id);
        if (setField != null) {
            switch (setField) {
                case STRING_FIELD: {
                    if (field.type == ComparableUnion.STRING_FIELD_FIELD_DESC.type) {
                        String string_field = iprot.readString();
                        return string_field;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
                case BINARY_FIELD: {
                    if (field.type == ComparableUnion.BINARY_FIELD_FIELD_DESC.type) {
                        ByteBuffer binary_field = iprot.readBinary();
                        return binary_field;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    return null;
                }
            }
            throw new IllegalStateException("setField wasn't null, but didn't match any of the case statements!");
        }
        TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
        return null;
    }

    protected void writeValue(TProtocol oprot) throws TException {
        switch ((_Fields)this.setField_) {
            case STRING_FIELD: {
                String string_field = (String)this.value_;
                oprot.writeString(string_field);
                return;
            }
            case BINARY_FIELD: {
                ByteBuffer binary_field = (ByteBuffer)this.value_;
                oprot.writeBinary(binary_field);
                return;
            }
        }
        throw new IllegalStateException("Cannot write union with unknown field " + this.setField_);
    }

    protected TField getFieldDesc(_Fields setField) {
        switch (setField) {
            case STRING_FIELD: {
                return STRING_FIELD_FIELD_DESC;
            }
            case BINARY_FIELD: {
                return BINARY_FIELD_FIELD_DESC;
            }
        }
        throw new IllegalArgumentException("Unknown field id " + (Object)((Object)setField));
    }

    protected TStruct getStructDesc() {
        return STRUCT_DESC;
    }

    protected _Fields enumForId(short id) {
        return _Fields.findByThriftIdOrThrow(id);
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public String getString_field() {
        if (this.getSetField() == _Fields.STRING_FIELD) {
            return (String)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'string_field' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setString_field(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.STRING_FIELD;
        this.value_ = value;
    }

    public ByteBuffer getBinary_field() {
        if (this.getSetField() == _Fields.BINARY_FIELD) {
            return (ByteBuffer)this.getFieldValue();
        }
        throw new RuntimeException("Cannot get field 'binary_field' because union is currently set to " + this.getFieldDesc((_Fields)((_Fields)this.getSetField())).name);
    }

    public void setBinary_field(ByteBuffer value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.setField_ = _Fields.BINARY_FIELD;
        this.value_ = value;
    }

    public boolean equals(Object other) {
        if (other instanceof ComparableUnion) {
            return this.equals((ComparableUnion)((Object)other));
        }
        return false;
    }

    public boolean equals(ComparableUnion other) {
        return other != null && this.getSetField() == other.getSetField() && this.getFieldValue().equals(other.getFieldValue());
    }

    public int compareTo(ComparableUnion other) {
        int lastComparison = TBaseHelper.compareTo((Comparable)((Comparable)this.getSetField()), (Comparable)((Comparable)other.getSetField()));
        if (lastComparison == 0) {
            return TBaseHelper.compareTo((Object)this.getFieldValue(), (Object)other.getFieldValue());
        }
        return lastComparison;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)((Object)((Object)this)).getClass().getName());
        TFieldIdEnum setField = this.getSetField();
        if (setField != null) {
            hcb.append(setField.getThriftFieldId());
            Object value = this.getFieldValue();
            if (value instanceof TEnum) {
                hcb.append(((TEnum)this.getFieldValue()).getValue());
            } else {
                hcb.append(value);
            }
        }
        return hcb.toHashCode();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.STRING_FIELD, new FieldMetaData("string_field", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.BINARY_FIELD, new FieldMetaData("binary_field", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ComparableUnion.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        STRING_FIELD(1, "string_field"),
        BINARY_FIELD(2, "binary_field");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return STRING_FIELD;
                }
                case 2: {
                    return BINARY_FIELD;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

