/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

public class Utils {
    public static Class<?> classForName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("failed to load class " + className, e);
        }
    }

    public static void ensureClassLoaderConsistency(Class<?> existingClass, ClassLoader classLoader) {
        Class<?> loadedClass;
        try {
            loadedClass = Class.forName(existingClass.getName(), true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!loadedClass.equals(existingClass)) {
            throw new RuntimeException("The class loader is incosistent with the class loader that initially loaded " + existingClass.getClass() + ". This can lead to various unexpected side effects.");
        }
    }
}

