/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.UninitializedMessageException;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.ListHelper;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protobufs {
    private static final Logger LOG = LoggerFactory.getLogger(Protobufs.class);
    public static final byte[] KNOWN_GOOD_POSITION_MARKER = new byte[]{41, -40, -43, 6, 88, -51, 76, 41, -78, -68, 87, -103, 33, 113, -67, -1};
    public static final byte NEWLINE_UTF8_BYTE = 10;
    public static final byte[] NEWLINE_UTF8_BYTES = new byte[]{10};
    public static final String IGNORE_KEY = "IGNORE";
    private static final String CLASS_CONF_PREFIX = "elephantbird.protobuf.class.for.";

    public static Class<? extends Message> getProtobufClass(String protoClassName) {
        return Protobufs.getProtobufClass(null, protoClassName);
    }

    private static Class<? extends Message> getProtobufClass(Configuration conf, String protoClassName) {
        Class<Object> protoClass = null;
        try {
            protoClass = conf == null ? Class.forName(protoClassName) : conf.getClassByName(protoClassName);
        }
        catch (ClassNotFoundException e) {
            protoClass = Protobufs.getInnerProtobufClass(protoClassName);
        }
        return protoClass.asSubclass(Message.class);
    }

    public static boolean useDynamicProtoMessage(Class<?> protoClass) {
        return protoClass == null || protoClass.getCanonicalName().equals(DynamicMessage.class.getCanonicalName());
    }

    public static Class<? extends Message> getInnerProtobufClass(String canonicalClassName) {
        String parentClass = canonicalClassName.substring(0, canonicalClassName.lastIndexOf("."));
        String subclass = canonicalClassName.substring(canonicalClassName.lastIndexOf(".") + 1);
        return Protobufs.getInnerClass(parentClass, subclass);
    }

    public static Class<? extends Message> getInnerClass(String canonicalParentName, String subclassName) {
        try {
            Class<?> outerClass = Class.forName(canonicalParentName);
            for (Class<?> innerClass : outerClass.getDeclaredClasses()) {
                if (!innerClass.getSimpleName().equals(subclassName)) continue;
                return innerClass.asSubclass(Message.class);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Could not find class with parent " + canonicalParentName + " and inner class " + subclassName, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    public static Message.Builder getMessageBuilder(Class<? extends Message> protoClass) {
        try {
            Method newBuilder = protoClass.getMethod("newBuilder", new Class[0]);
            return (Message.Builder)newBuilder.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method newBuilder in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method newBuilder in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method newBuilder in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
    }

    public static Descriptors.Descriptor getMessageDescriptor(Class<? extends Message> protoClass) {
        try {
            Method getDescriptor = protoClass.getMethod("getDescriptor", new Class[0]);
            return (Descriptors.Descriptor)getDescriptor.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method getDescriptor in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method getDescriptor in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method getDescriptor in class " + protoClass, (Throwable)e);
            return null;
        }
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> protoClass) {
        return Lists.transform((List)Protobufs.getMessageDescriptor(protoClass).getFields(), (Function)new Function<Descriptors.FieldDescriptor, String>(){

            public String apply(Descriptors.FieldDescriptor f) {
                return f.getName();
            }
        });
    }

    public static Descriptors.Descriptor makeMessageDescriptor(DescriptorProtos.DescriptorProto descProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescP = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descProto).build();
        Descriptors.FileDescriptor[] fileDescs = new Descriptors.FileDescriptor[]{};
        Descriptors.FileDescriptor dynamicDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescP, (Descriptors.FileDescriptor[])fileDescs);
        return dynamicDescriptor.findMessageTypeByName(descProto.getName());
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> protoClass, Map<String, String> fieldNameTranslations) {
        return Protobufs.getMessageFieldNames(Protobufs.getMessageDescriptor(protoClass), fieldNameTranslations);
    }

    public static List<String> getMessageFieldNames(Descriptors.Descriptor descriptor, Map<String, String> fieldNameTranslations) {
        Function<Descriptors.FieldDescriptor, String> fieldTransformer = Protobufs.getFieldTransformerFor(fieldNameTranslations);
        return ListHelper.filter(Lists.transform((List)descriptor.getFields(), fieldTransformer), Predicates.notNull());
    }

    public static Function<Descriptors.FieldDescriptor, String> getFieldTransformerFor(final Map<String, String> fieldNameTranslations) {
        return new Function<Descriptors.FieldDescriptor, String>(){

            public String apply(Descriptors.FieldDescriptor f) {
                String name = f.getName();
                if (fieldNameTranslations != null && fieldNameTranslations.containsKey(name)) {
                    name = (String)fieldNameTranslations.get(name);
                }
                if (Protobufs.IGNORE_KEY.equals(name)) {
                    name = null;
                }
                return name;
            }
        };
    }

    public static <M extends Message> M parseFrom(Class<M> protoClass, byte[] messageBytes) {
        try {
            Method parseFrom = protoClass.getMethod("parseFrom", byte[].class);
            return (M)((Message)parseFrom.invoke(null, new Object[]{messageBytes}));
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find method parseFrom in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Could not access method parseFrom in class " + protoClass, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error("Error invoking method parseFrom in class " + protoClass, (Throwable)e);
            return null;
        }
    }

    public static DynamicMessage parseDynamicFrom(Class<? extends Message> protoClass, byte[] messageBytes) {
        try {
            return DynamicMessage.parseFrom((Descriptors.Descriptor)Protobufs.getMessageDescriptor(protoClass), (byte[])messageBytes);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Protocol buffer parsing error in parseDynamicFrom", (Throwable)e);
        }
        catch (UninitializedMessageException ume) {
            LOG.error("Uninitialized Message error in parseDynamicFrom " + protoClass.getName(), (Throwable)ume);
        }
        return null;
    }

    public static Message instantiateFromClassName(String canonicalClassName) {
        Class<? extends Message> protoClass = Protobufs.getInnerProtobufClass(canonicalClassName);
        Message.Builder builder = Protobufs.getMessageBuilder(protoClass);
        return builder.build();
    }

    public static <M extends Message> M instantiateFromClass(Class<M> protoClass) {
        return Protobufs.parseFrom(protoClass, new byte[0]);
    }

    public static Message addField(Message m, String name, Object value) {
        Message.Builder builder = m.toBuilder();
        Protobufs.setFieldByName(builder, name, value);
        return builder.build();
    }

    public static void setFieldByName(Message.Builder builder, String name, Object value) {
        Descriptors.FieldDescriptor fieldDescriptor = builder.getDescriptorForType().findFieldByName(name);
        if (value == null) {
            builder.clearField(fieldDescriptor);
        } else {
            builder.setField(fieldDescriptor, value);
        }
    }

    public static boolean isFieldSetByName(Message message, String name) {
        return message.hasField(message.getDescriptorForType().findFieldByName(name));
    }

    public static Object getFieldByName(Message message, String name) {
        return message.getField(message.getDescriptorForType().findFieldByName(name));
    }

    public static boolean hasFieldByName(Message message, String name) {
        return message.getDescriptorForType().findFieldByName(name) != null;
    }

    public static Descriptors.FieldDescriptor.Type getTypeByName(Message message, String name) {
        return message.getDescriptorForType().findFieldByName(name).getType();
    }

    public static <M extends Message> TypeRef<M> getTypeRef(String protoClassName) {
        return new TypeRef<M>(Protobufs.getProtobufClass(protoClassName)){};
    }

    public static <M extends Message> TypeRef<M> getTypeRef(Configuration jobConf, Class<?> genericClass) {
        String className = jobConf.get(CLASS_CONF_PREFIX + genericClass.getName());
        if (className == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + genericClass.getName() + " is not set");
        }
        return new TypeRef<M>(Protobufs.getProtobufClass(jobConf, className)){};
    }

    public static void setClassConf(Configuration jobConf, Class<?> genericClass, Class<? extends Message> protoClass) {
        HadoopUtils.setClassConf(jobConf, CLASS_CONF_PREFIX + genericClass.getName(), protoClass);
    }

    public static Text toText(Message message) {
        return new Text(message.toByteArray());
    }

    public static <B extends Message.Builder> B mergeFromText(B builder, Text bytes) throws InvalidProtocolBufferException {
        Message.Builder b = builder.mergeFrom(bytes.getBytes());
        return (B)b;
    }

    public static void writeFieldNoTag(CodedOutputStream output, Descriptors.FieldDescriptor fd, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (fd.isRepeated()) {
            List values = (List)value;
            for (Object obj : values) {
                Protobufs.writeSingleFieldNoTag(output, fd, obj);
            }
        } else {
            Protobufs.writeSingleFieldNoTag(output, fd, value);
        }
    }

    private static void writeSingleFieldNoTag(CodedOutputStream output, Descriptors.FieldDescriptor fd, Object value) throws IOException {
        switch (fd.getType()) {
            case DOUBLE: {
                output.writeDoubleNoTag(((Double)value).doubleValue());
                break;
            }
            case FLOAT: {
                output.writeFloatNoTag(((Float)value).floatValue());
                break;
            }
            case INT64: 
            case UINT64: {
                output.writeInt64NoTag(((Long)value).longValue());
                break;
            }
            case INT32: {
                output.writeInt32NoTag(((Integer)value).intValue());
                break;
            }
            case FIXED64: {
                output.writeFixed64NoTag(((Long)value).longValue());
                break;
            }
            case FIXED32: {
                output.writeFixed32NoTag(((Integer)value).intValue());
                break;
            }
            case BOOL: {
                output.writeBoolNoTag(((Boolean)value).booleanValue());
                break;
            }
            case STRING: {
                output.writeStringNoTag((String)value);
                break;
            }
            case GROUP: 
            case MESSAGE: {
                output.writeMessageNoTag((MessageLite)((Message)value));
                break;
            }
            case BYTES: {
                output.writeBytesNoTag((ByteString)value);
                break;
            }
            case UINT32: {
                output.writeUInt32NoTag(((Integer)value).intValue());
                break;
            }
            case ENUM: {
                output.writeEnumNoTag(((ProtocolMessageEnum)value).getNumber());
                break;
            }
            case SFIXED32: {
                output.writeSFixed32NoTag(((Integer)value).intValue());
                break;
            }
            case SFIXED64: {
                output.writeSFixed64NoTag(((Long)value).longValue());
                break;
            }
            case SINT32: {
                output.writeSInt32NoTag(((Integer)value).intValue());
                break;
            }
            case SINT64: {
                output.writeSInt64NoTag((long)((Integer)value).intValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + fd.getType() + " for " + fd.getFullName());
            }
        }
    }

    public static void setFieldValue(CodedInputStream input, Descriptors.FieldDescriptor fd, Message.Builder builder) throws IOException {
        builder.setField(fd, Protobufs.readFieldNoTag(input, fd, builder));
    }

    public static Object readFieldNoTag(CodedInputStream input, Descriptors.FieldDescriptor fd, Message.Builder enclosingBuilder) throws IOException {
        if (!fd.isRepeated()) {
            return Protobufs.readSingleFieldNoTag(input, fd, enclosingBuilder);
        }
        ArrayList values = Lists.newArrayList();
        while (!input.isAtEnd()) {
            values.add(Protobufs.readSingleFieldNoTag(input, fd, enclosingBuilder));
        }
        return values;
    }

    private static Object readSingleFieldNoTag(CodedInputStream input, Descriptors.FieldDescriptor fd, Message.Builder enclosingBuilder) throws IOException {
        switch (fd.getType()) {
            case DOUBLE: {
                return input.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(input.readFloat());
            }
            case INT64: 
            case UINT64: {
                return input.readInt64();
            }
            case INT32: {
                return input.readInt32();
            }
            case FIXED64: {
                return input.readFixed64();
            }
            case FIXED32: {
                return input.readFixed32();
            }
            case BOOL: {
                return input.readBool();
            }
            case STRING: {
                return input.readString();
            }
            case GROUP: 
            case MESSAGE: {
                Message.Builder fieldBuilder = enclosingBuilder.newBuilderForField(fd);
                input.readMessage((MessageLite.Builder)fieldBuilder, null);
                return fieldBuilder.build();
            }
            case BYTES: {
                return input.readBytes();
            }
            case UINT32: {
                return input.readUInt32();
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor eVal = fd.getEnumType().findValueByNumber(input.readEnum());
                return eVal != null ? eVal : fd.getDefaultValue();
            }
            case SFIXED32: {
                return input.readSFixed32();
            }
            case SFIXED64: {
                return input.readSFixed64();
            }
            case SINT32: {
                return input.readSInt32();
            }
            case SINT64: {
                return input.readSInt64();
            }
        }
        throw new IllegalArgumentException("Unknown type " + fd.getType() + " for " + fd.getFullName());
    }
}

