/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.thrift;

import com.twitter.elephantbird.thrift.ThriftBinaryProtocol;
import java.nio.ByteBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.transport.TTransport;

public class ThriftProtocolWrapper
extends TProtocol {
    protected final TProtocol wrapped;

    public ThriftProtocolWrapper(TProtocol wrapped) {
        super(wrapped.getTransport());
        this.wrapped = wrapped;
    }

    public TTransport getTransport() {
        return this.wrapped.getTransport();
    }

    public void writeMessageBegin(TMessage message) throws TException {
        this.wrapped.writeMessageBegin(message);
    }

    public void writeMessageEnd() throws TException {
        this.wrapped.writeMessageEnd();
    }

    public void writeStructBegin(TStruct struct) throws TException {
        this.wrapped.writeStructBegin(struct);
    }

    public void writeStructEnd() throws TException {
        this.wrapped.writeStructEnd();
    }

    public void writeFieldBegin(TField field) throws TException {
        this.wrapped.writeFieldBegin(field);
    }

    public void writeFieldEnd() throws TException {
        this.wrapped.writeFieldEnd();
    }

    public void writeFieldStop() throws TException {
        this.wrapped.writeFieldStop();
    }

    public void writeMapBegin(TMap map) throws TException {
        this.wrapped.writeMapBegin(map);
    }

    public void writeMapEnd() throws TException {
        this.wrapped.writeMapEnd();
    }

    public void writeListBegin(TList list) throws TException {
        this.wrapped.writeListBegin(list);
    }

    public void writeListEnd() throws TException {
        this.wrapped.writeListEnd();
    }

    public void writeSetBegin(TSet set) throws TException {
        this.wrapped.writeSetBegin(set);
    }

    public void writeSetEnd() throws TException {
        this.wrapped.writeSetEnd();
    }

    public void writeBool(boolean b) throws TException {
        this.wrapped.writeBool(b);
    }

    public void writeByte(byte b) throws TException {
        this.wrapped.writeByte(b);
    }

    public void writeI16(short i16) throws TException {
        this.wrapped.writeI16(i16);
    }

    public void writeI32(int i32) throws TException {
        this.wrapped.writeI32(i32);
    }

    public void writeI64(long i64) throws TException {
        this.wrapped.writeI64(i64);
    }

    public void writeDouble(double dub) throws TException {
        this.wrapped.writeDouble(dub);
    }

    public void writeString(String str) throws TException {
        this.wrapped.writeString(str);
    }

    public void writeBinary(ByteBuffer buf) throws TException {
        this.wrapped.writeBinary(buf);
    }

    public TMessage readMessageBegin() throws TException {
        return this.wrapped.readMessageBegin();
    }

    public void readMessageEnd() throws TException {
        this.wrapped.readMessageEnd();
    }

    public TStruct readStructBegin() throws TException {
        return this.wrapped.readStructBegin();
    }

    public void readStructEnd() throws TException {
        this.wrapped.readStructEnd();
    }

    public TField readFieldBegin() throws TException {
        return this.wrapped.readFieldBegin();
    }

    public void readFieldEnd() throws TException {
        this.wrapped.readFieldEnd();
    }

    public TMap readMapBegin() throws TException {
        TMap map = this.wrapped.readMapBegin();
        ThriftBinaryProtocol.checkContainerElemType(map.keyType);
        ThriftBinaryProtocol.checkContainerElemType(map.valueType);
        return map;
    }

    public void readMapEnd() throws TException {
        this.wrapped.readMapEnd();
    }

    public TList readListBegin() throws TException {
        TList list = this.wrapped.readListBegin();
        ThriftBinaryProtocol.checkContainerElemType(list.elemType);
        return list;
    }

    public void readListEnd() throws TException {
        this.wrapped.readListEnd();
    }

    public TSet readSetBegin() throws TException {
        TSet set = this.wrapped.readSetBegin();
        ThriftBinaryProtocol.checkContainerElemType(set.elemType);
        return set;
    }

    public void readSetEnd() throws TException {
        this.wrapped.readSetEnd();
    }

    public boolean readBool() throws TException {
        return this.wrapped.readBool();
    }

    public byte readByte() throws TException {
        return this.wrapped.readByte();
    }

    public short readI16() throws TException {
        return this.wrapped.readI16();
    }

    public int readI32() throws TException {
        return this.wrapped.readI32();
    }

    public long readI64() throws TException {
        return this.wrapped.readI64();
    }

    public double readDouble() throws TException {
        return this.wrapped.readDouble();
    }

    public String readString() throws TException {
        return this.wrapped.readString();
    }

    public ByteBuffer readBinary() throws TException {
        return this.wrapped.readBinary();
    }

    public void reset() {
        this.wrapped.reset();
    }
}

