/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.BinaryBlockReader;
import com.twitter.elephantbird.mapreduce.io.ProtobufConverter;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufBlockReader<M extends Message>
extends BinaryBlockReader<M> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufBlockReader.class);

    public ProtobufBlockReader(InputStream in, TypeRef<M> typeRef) {
        super(in, ProtobufConverter.newInstance(typeRef));
        LOG.info("ProtobufReader, my typeClass is " + typeRef.getRawClass());
    }

    public boolean readProtobuf(ProtobufWritable<M> message) throws IOException {
        return this.readNext(message);
    }

    public boolean readProtobufBytes(BytesWritable message) throws IOException {
        return this.readNextProtoBytes(message);
    }
}

