/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input.combine;

import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.combine.CompositeInputSplit;
import com.twitter.elephantbird.mapreduce.input.combine.CompositeRecordReader;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.SplitUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateCombineFileInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateCombineFileInputFormat.class);
    public static final String USE_COMBINED_INPUT_FORMAT = "elephantbird.use.combine.input.format";
    public static final String COMBINED_INPUT_FORMAT_DELEGATE = "elephantbird.combine.input.format.delegate";
    private InputFormat<K, V> delegate;
    private long maxSplitSize;
    private long minSplitSizeNode;
    private long minSplitSizeRack;

    public static void setUseCombinedInputFormat(Configuration conf) {
        conf.setBoolean(USE_COMBINED_INPUT_FORMAT, true);
    }

    public static void setCombinedInputFormatDelegate(Configuration conf, Class<? extends InputFormat> clazz) {
        HadoopUtils.setClassConf(conf, COMBINED_INPUT_FORMAT_DELEGATE, clazz);
    }

    public static void setDelegateInputFormat(JobConf jobConf, Class<? extends InputFormat> inputFormat) {
        DeprecatedInputFormatWrapper.setInputFormat(DelegateCombineFileInputFormat.class, jobConf);
        DelegateCombineFileInputFormat.setCombinedInputFormatDelegate((Configuration)jobConf, inputFormat);
    }

    public static void setDelegateInputFormatHadoop2(Configuration conf, Class<? extends InputFormat> inputFormat) {
        conf.setClass("mapreduce.inputformat.class", DelegateCombineFileInputFormat.class, InputFormat.class);
        DelegateCombineFileInputFormat.setCombinedInputFormatDelegate(conf, inputFormat);
    }

    private void initInputFormat(Configuration conf) throws IOException {
        if (this.delegate == null) {
            Class delegateClass = conf.getClass(COMBINED_INPUT_FORMAT_DELEGATE, null, InputFormat.class);
            if (delegateClass == null) {
                throw new IOException("No delegate class was set on key: elephantbird.combine.input.format.delegate");
            }
            this.delegate = (InputFormat)ReflectionUtils.newInstance((Class)delegateClass, (Configuration)conf);
        }
    }

    public DelegateCombineFileInputFormat() {
    }

    public DelegateCombineFileInputFormat(InputFormat<K, V> delegate) {
        this.delegate = delegate;
    }

    private boolean shouldCombine(Configuration conf) {
        return conf.getBoolean(USE_COMBINED_INPUT_FORMAT, false);
    }

    public RecordReader createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Configuration conf = HadoopCompat.getConfiguration((JobContext)taskAttemptContext);
        this.initInputFormat(conf);
        if (this.shouldCombine(conf)) {
            return new CompositeRecordReader<K, V>(this.delegate);
        }
        return this.delegate.createRecordReader(inputSplit, taskAttemptContext);
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Configuration conf = HadoopCompat.getConfiguration((JobContext)job);
        this.initInputFormat(conf);
        try {
            if (this.shouldCombine(conf)) {
                List inputSplits = this.delegate.getSplits(job);
                ArrayList<InputSplit> combinedInputSplits = new ArrayList<InputSplit>();
                for (CompositeInputSplit split : SplitUtil.getCombinedCompositeSplits(inputSplits, conf)) {
                    split.setConf(conf);
                    combinedInputSplits.add(split);
                }
                return combinedInputSplits;
            }
            return this.delegate.getSplits(job);
        }
        catch (InterruptedException e) {
            LOG.error("Thread interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }
}

