/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input.combine;

import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import com.twitter.elephantbird.mapreduce.input.combine.CompositeInputSplit;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeRecordReader<K, V>
extends RecordReader<K, V>
implements MapredInputFormatCompatible<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeRecordReader.class);
    private final InputFormat<K, V> delegate;
    private final Queue<DelayedRecordReader> recordReaders = new LinkedList<DelayedRecordReader>();
    private RecordReader<K, V> currentRecordReader;
    private K key;
    private V value;
    private int recordReadersCount = 0;
    private int currentRecordReaderIndex = -1;
    private long totalSplitLengths = 0L;
    private long[] cumulativeSplitLengths;
    private long[] splitLengths;
    private boolean haveInitializedFirstRecordReader = false;

    public CompositeRecordReader(InputFormat<K, V> delegate) {
        this.delegate = delegate;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (!(inputSplit instanceof CompositeInputSplit)) {
            throw new IOException("InputSplit must be a CompositeInputSplit. Received: " + inputSplit);
        }
        List<InputSplit> splits = ((CompositeInputSplit)inputSplit).getSplits();
        int numSplits = splits.size();
        this.cumulativeSplitLengths = new long[numSplits];
        this.splitLengths = new long[numSplits];
        long localTotalSplitLength = 0L;
        for (int i = 0; i < numSplits; ++i) {
            long splitLength;
            InputSplit split = splits.get(i);
            this.recordReaders.add(new DelayedRecordReader(split, taskAttemptContext));
            this.splitLengths[i] = splitLength = split.getLength();
            this.cumulativeSplitLengths[i] = localTotalSplitLength;
            localTotalSplitLength += splitLength;
        }
        this.totalSplitLengths = localTotalSplitLength;
        this.recordReadersCount = this.recordReaders.size();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.currentRecordReader != null || !this.recordReaders.isEmpty()) {
            if (this.currentRecordReader != null) {
                if (this.currentRecordReader.nextKeyValue()) {
                    return true;
                }
                this.currentRecordReader.close();
                this.currentRecordReader = null;
            }
            if (this.recordReaders.isEmpty()) {
                return false;
            }
            this.currentRecordReader = this.recordReaders.remove().createRecordReader();
            ++this.currentRecordReaderIndex;
            if (!this.haveInitializedFirstRecordReader) {
                this.key = this.currentRecordReader.getCurrentKey();
                this.value = this.currentRecordReader.getCurrentValue();
                this.haveInitializedFirstRecordReader = true;
                continue;
            }
            this.setKeyValue(this.key, this.value);
        }
        return false;
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)this.currentRecordReader.getCurrentKey();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)this.currentRecordReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.recordReadersCount < 1) {
            return 1.0f;
        }
        if (this.totalSplitLengths == 0L) {
            return 0.0f;
        }
        long cur = this.currentRecordReader == null ? 0L : (long)(this.currentRecordReader.getProgress() * (float)this.splitLengths[this.currentRecordReaderIndex]);
        return 1.0f * (float)(cur + this.cumulativeSplitLengths[this.currentRecordReaderIndex]) / (float)this.totalSplitLengths;
    }

    public void close() throws IOException {
        if (this.currentRecordReader != null) {
            this.currentRecordReader.close();
        }
    }

    @Override
    public void setKeyValue(K key, V value) {
        ((MapredInputFormatCompatible)this.currentRecordReader).setKeyValue(key, value);
        this.key = key;
        this.value = value;
    }

    private class DelayedRecordReader {
        private InputSplit inputSplit;
        private TaskAttemptContext taskAttemptContext;

        public DelayedRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
            this.inputSplit = inputSplit;
            this.taskAttemptContext = taskAttemptContext;
        }

        public RecordReader<K, V> createRecordReader() throws IOException, InterruptedException {
            RecordReader reader = CompositeRecordReader.this.delegate.createRecordReader(this.inputSplit, this.taskAttemptContext);
            if (!(reader instanceof MapredInputFormatCompatible)) {
                throw new RuntimeException("RecordReader does not implement MapredInputFormatCompatible. Received: " + reader);
            }
            reader.initialize(this.inputSplit, this.taskAttemptContext);
            return reader;
        }
    }
}

