/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.collect.Lists;
import com.hadoop.compression.lzo.LzoIndex;
import com.twitter.elephantbird.util.HadoopCompat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoInputFormat.class);
    private final PathFilter hiddenPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith(".") && !name.startsWith("_");
        }
    };
    private final PathFilter visibleLzoFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return LzoInputFormat.this.hiddenPathFilter.accept(path) && name.endsWith(".lzo");
        }
    };
    private final PathFilter lzoIndexFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return LzoInputFormat.this.hiddenPathFilter.accept(path) && name.endsWith(".index");
        }
    };
    private final Map<Path, LzoSplitStatus> splitStatusMap = new HashMap<Path, LzoSplitStatus>();

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List files = super.listStatus(job);
        ArrayList results = Lists.newArrayList();
        boolean recursive = HadoopCompat.getConfiguration((JobContext)job).getBoolean("mapred.input.dir.recursive", false);
        for (FileStatus fileStatus : files) {
            FileSystem fs = fileStatus.getPath().getFileSystem(HadoopCompat.getConfiguration((JobContext)job));
            this.addInputPath(results, fs, fileStatus, recursive);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total lzo input paths to process : " + results.size());
        }
        return results;
    }

    protected void addInputPath(List<FileStatus> results, FileSystem fs, FileStatus pathStat, boolean recursive) throws IOException {
        Path path = pathStat.getPath();
        if (pathStat.isDir()) {
            if (recursive) {
                for (FileStatus stat : fs.listStatus(path, this.hiddenPathFilter)) {
                    this.addInputPath(results, fs, stat, recursive);
                }
            }
        } else if (this.visibleLzoFilter.accept(path)) {
            results.add(pathStat);
            this.lzoSplitStatus(path).lzoFileStatus = pathStat;
        } else if (this.lzoIndexFilter.accept(path)) {
            String lzoIndexName = path.getName();
            String lzoName = lzoIndexName.substring(0, lzoIndexName.length() - ".index".length());
            Path lzoPath = new Path(path.getParent(), lzoName);
            this.lzoSplitStatus(lzoPath).lzoIndexFileStatus = pathStat;
        }
    }

    private LzoSplitStatus lzoSplitStatus(Path path) {
        LzoSplitStatus lzoSplitStatus = this.splitStatusMap.get(path);
        if (lzoSplitStatus == null) {
            lzoSplitStatus = new LzoSplitStatus();
            this.splitStatusMap.put(path, lzoSplitStatus);
        }
        return lzoSplitStatus;
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        LzoSplitStatus lzoSplitStatus = this.splitStatusMap.get(filename);
        return lzoSplitStatus != null && lzoSplitStatus.lzoIndexFileStatus != null;
    }

    private List<InputSplit> getSplitsInternal(JobContext job) throws IOException {
        List defaultSplits = super.getSplits(job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        Path prevFile = null;
        LzoIndex prevIndex = null;
        for (InputSplit genericSplit : defaultSplits) {
            LzoIndex index;
            FileSplit fileSplit = (FileSplit)genericSplit;
            Path file = fileSplit.getPath();
            LzoSplitStatus lzoSplitStatus = this.splitStatusMap.get(file);
            if (file.equals(prevFile)) {
                index = prevIndex;
            } else {
                FileStatus indexFileStatus;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Cached file status " + lzoSplitStatus);
                }
                index = (indexFileStatus = lzoSplitStatus.lzoIndexFileStatus) == null ? new LzoIndex() : LzoIndex.readIndex((FileSystem)file.getFileSystem(HadoopCompat.getConfiguration((JobContext)job)), (Path)file);
                prevFile = file;
                prevIndex = index;
            }
            if (index == null) {
                throw new IOException("Index not found for " + file);
            }
            if (index.isEmpty()) {
                result.add((InputSplit)fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long lzoStart = index.alignSliceStartToIndex(start, end);
            long lzoEnd = index.alignSliceEndToIndex(end, lzoSplitStatus.lzoFileStatus.getLen());
            if (lzoStart == -1L || lzoEnd == -1L) continue;
            result.add((InputSplit)new FileSplit(file, lzoStart, lzoEnd - lzoStart, fileSplit.getLocations()));
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added LZO split for " + file + "[start=" + lzoStart + ", length=" + (lzoEnd - lzoStart) + "]");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        try {
            List<InputSplit> list = this.getSplitsInternal(job);
            return list;
        }
        finally {
            this.splitStatusMap.clear();
        }
    }

    private static class LzoSplitStatus {
        private FileStatus lzoFileStatus;
        private FileStatus lzoIndexFileStatus;

        private LzoSplitStatus() {
        }

        public String toString() {
            return LzoSplitStatus.class.getName() + "[ lzo=" + this.lzoFileStatus + " index=" + this.lzoIndexFileStatus + " ]";
        }
    }
}

