/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.input.MapredInputFormatCompatible;
import com.twitter.elephantbird.mapreduce.io.BinaryBlockReader;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.mapreduce.io.DecodeException;
import com.twitter.elephantbird.util.HadoopCompat;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoBinaryBlockRecordReader<M, W extends BinaryWritable<M>>
extends LzoRecordReader<LongWritable, W>
implements MapredInputFormatCompatible<LongWritable, W> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBinaryBlockRecordReader.class);
    private LongWritable key_ = new LongWritable();
    private W value_;
    private final TypeRef<M> typeRef_;
    boolean updatePosition = false;
    private final BinaryBlockReader<M> reader_;
    private Counter recordsReadCounter;
    private Counter recordErrorsCounter;
    private Counter recordsSkippedCounter;
    private final BinaryConverter<M> deserializer_;

    public LzoBinaryBlockRecordReader(TypeRef<M> typeRef, BinaryBlockReader<M> reader, W binaryWritable) {
        this.value_ = binaryWritable;
        this.reader_ = reader;
        this.typeRef_ = typeRef;
        this.deserializer_ = reader.getConverter();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this.reader_ != null) {
            this.reader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public W getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input, Configuration conf) throws IOException {
        this.reader_.setInputStream(input);
    }

    @Override
    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        String group = "LzoBlocks of " + this.typeRef_.getRawClass().getName();
        this.recordsReadCounter = HadoopUtils.getCounter((JobContext)context, group, "Records Read");
        this.recordsSkippedCounter = HadoopUtils.getCounter((JobContext)context, group, "Records Skipped");
        this.recordErrorsCounter = HadoopUtils.getCounter((JobContext)context, group, "Errors");
        super.initialize(genericSplit, context);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        LOG.debug("LzoProtobufBlockRecordReader.skipToNextSyncPoint called with atFirstRecord = " + atFirstRecord);
        this.updatePosition = !atFirstRecord;
        this.reader_.parseNextBlock(!atFirstRecord);
    }

    @Override
    public void setKeyValue(LongWritable key, W value) {
        this.key_ = key;
        this.value_ = value;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (true) {
            byte[] byteArray;
            if (this.pos_ > this.end_) {
                this.reader_.markNoMoreNewBlocks();
            }
            if ((byteArray = this.reader_.readNextProtoBytes()) == null) {
                return false;
            }
            this.errorTracker.incRecords();
            Object decoded = null;
            try {
                decoded = this.deserializer_.fromBytes(byteArray);
            }
            catch (DecodeException e) {
                this.errorTracker.incErrors(e);
                HadoopCompat.incrementCounter((Counter)this.recordErrorsCounter, (long)1L);
                continue;
            }
            if (this.updatePosition) {
                this.pos_ = this.getLzoFilePos();
                this.updatePosition = false;
            }
            if (decoded != null) {
                this.key_.set(this.pos_);
                ((BinaryWritable)this.value_).set(decoded);
                this.pos_ = this.getLzoFilePos();
                HadoopCompat.incrementCounter((Counter)this.recordsReadCounter, (long)1L);
                return true;
            }
            HadoopCompat.incrementCounter((Counter)this.recordsSkippedCounter, (long)1L);
        }
    }
}

