/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.io.DecodeException;
import java.util.Arrays;

public class Base64Codec {
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] IA = new int[256];

    public static final byte[] encodeToByte(byte[] sArr, boolean lineSep) {
        return Base64Codec.encodeToByte(sArr, 0, sArr != null ? sArr.length : 0, lineSep);
    }

    public static final byte[] encodeToByte(byte[] sArr, int sOff, int sLen, boolean lineSep) {
        if (sArr == null || sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        byte[] dArr = new byte[dLen];
        int s = sOff;
        int d = 0;
        int cc = 0;
        while (s < sOff + eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = (byte)CA[i >>> 18 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 12 & 0x3F];
            dArr[d++] = (byte)CA[i >>> 6 & 0x3F];
            dArr[d++] = (byte)CA[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[sOff + eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sOff + sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = (byte)CA[i >> 12];
            dArr[dLen - 3] = (byte)CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? (int)CA[i & 0x3F] : 61;
            dArr[dLen - 1] = 61;
        }
        return dArr;
    }

    public static final byte[] decode(byte[] sArr) throws DecodeException {
        return Base64Codec.decode(sArr, 0, sArr.length);
    }

    public static final byte[] decode(byte[] sArr, int sOff, int sLen) throws DecodeException {
        try {
            return Base64Codec.doDecode(sArr, sOff, sLen);
        }
        catch (RuntimeException e) {
            throw new DecodeException(e);
        }
    }

    private static final byte[] doDecode(byte[] sArr, int sOff, int sLen) {
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (IA[sArr[sOff + i] & 0xFF] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && IA[sArr[sOff + --i] & 0xFF] <= 0) {
            if (sArr[sOff + i] != 61) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = IA[sArr[sOff + s++] & 0xFF]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public static final byte[] decodeFast(byte[] sArr, int sLen) throws DecodeException {
        try {
            return Base64Codec.doDecodeFast(sArr, sLen);
        }
        catch (RuntimeException e) {
            throw new DecodeException(e);
        }
    }

    private static final byte[] doDecodeFast(byte[] sArr, int sLen) {
        int sIx;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && IA[sArr[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == 61 ? (sArr[eIx - 1] == 61 ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = IA[sArr[sIx++]] << 18 | IA[sArr[sIx++]] << 12 | IA[sArr[sIx++]] << 6 | IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    static {
        Arrays.fill(IA, -1);
        int iS = CA.length;
        for (int i = 0; i < iS; ++i) {
            Base64Codec.IA[Base64Codec.CA[i]] = i;
        }
        Base64Codec.IA[61] = 0;
    }
}

