/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.Pair;
import com.twitter.elephantbird.util.Protobufs;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;

public class ThriftToDynamicProto<T extends TBase<?, ?>> {
    private static final Logger LOG = LogManager.getLogger(ThriftToDynamicProto.class);
    DynamicMessage.Builder protoBuilder;
    Descriptors.Descriptor msgDescriptor;
    Message protoObj;

    public ThriftToDynamicProto(Class<T> thriftClass) throws Descriptors.DescriptorValidationException {
        this(thriftClass, new ArrayList<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>>());
    }

    public ThriftToDynamicProto(Class<T> thriftClass, List<Pair<String, DescriptorProtos.FieldDescriptorProto.Type>> extraFields) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto.Builder desBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        desBuilder.setName("dynaMessage");
        TStructDescriptor fieldDesc = TStructDescriptor.getInstance(thriftClass);
        int maxThriftId = 0;
        for (TStructDescriptor.Field tField : fieldDesc.getFields()) {
            DescriptorProtos.FieldDescriptorProto.Type protoType = this.thriftTypeToProtoType(tField);
            maxThriftId = Math.max(tField.getFieldId(), maxThriftId);
            this.addField(desBuilder, tField.getName(), tField.getFieldId() + 1, protoType);
        }
        int extraFieldIdx = maxThriftId + 1;
        for (Pair<String, DescriptorProtos.FieldDescriptorProto.Type> extraField : extraFields) {
            this.addField(desBuilder, extraField.getFirst(), ++extraFieldIdx, extraField.getSecond());
        }
        this.msgDescriptor = Protobufs.makeMessageDescriptor(desBuilder.build());
        this.protoBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.msgDescriptor);
    }

    private void addField(DescriptorProtos.DescriptorProto.Builder builder, String name, int fieldIdx, DescriptorProtos.FieldDescriptorProto.Type type) {
        DescriptorProtos.FieldDescriptorProto.Builder fdBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder().setName(name).setNumber(fieldIdx).setType(type);
        builder.addField(fdBuilder.build());
    }

    public DynamicMessage convert(T thriftObj) {
        DynamicMessage.Builder builder = this.protoBuilder.clone();
        TStructDescriptor fieldDesc = TStructDescriptor.getInstance(thriftObj.getClass());
        int fieldId = 0;
        for (TStructDescriptor.Field tField : fieldDesc.getFields()) {
            Object fieldValue;
            Descriptors.FieldDescriptor protoFieldDesc = this.msgDescriptor.findFieldByName(tField.getName());
            if (protoFieldDesc == null) {
                throw new RuntimeException("Field " + tField.getName() + " not found in dynamic protobuf.");
            }
            if ((fieldValue = fieldDesc.getFieldValue(fieldId++, (TBase)thriftObj)) == null) continue;
            if (tField.isEnum()) {
                fieldValue = fieldValue.toString();
            } else if (tField.isBuffer()) {
                fieldValue = ByteString.copyFrom((byte[])((byte[])fieldValue));
            }
            builder.setField(protoFieldDesc, fieldValue);
        }
        return builder.build();
    }

    private DescriptorProtos.FieldDescriptorProto.Type thriftTypeToProtoType(TStructDescriptor.Field tField) {
        byte thriftType = tField.getType();
        switch (thriftType) {
            case 2: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL;
            }
            case 3: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 4: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            }
            case 6: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 8: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            }
            case 10: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            }
            case 11: {
                return tField.isBuffer() ? DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES : DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
            case 16: {
                return DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            }
        }
        throw new IllegalArgumentException("Can't map Thrift type " + thriftType + " to a ProtoBuf type");
    }
}

