/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.hadoop.compression.lzo.LzopCodec;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LzoUtils {
    public static final Logger LOG = LogManager.getLogger(LzoUtils.class);
    private static boolean isLzopIndexSupported = false;

    public static DataOutputStream getIndexedLzoOutputStream(Configuration conf, Path path) throws IOException {
        LzopCodec codec = new LzopCodec();
        codec.setConf(conf);
        final Path file = path;
        final FileSystem fs = file.getFileSystem(conf);
        FSDataOutputStream fileOut = fs.create(file, false);
        FSDataOutputStream indexOut = null;
        if (conf.getBoolean("elephantbird.lzo.output.index", false)) {
            if (isLzopIndexSupported) {
                Path indexPath = file.suffix(".index.tmp");
                indexOut = fs.create(indexPath, false);
            } else {
                LOG.warn((Object)"elephantbird.lzo.output.index is enabled, but LzopCodec does not have createIndexedOutputStream method. Please upgrade hadoop-lzo.");
            }
        }
        final boolean isIndexed = indexOut != null;
        CompressionOutputStream out = isIndexed ? codec.createIndexedOutputStream((OutputStream)fileOut, indexOut) : codec.createOutputStream((OutputStream)fileOut);
        return new DataOutputStream((OutputStream)out){

            @Override
            public void close() throws IOException {
                super.close();
                if (isIndexed) {
                    Path tmpPath = file.suffix(".index.tmp");
                    FileStatus stat = fs.getFileStatus(file);
                    if (stat.getLen() <= stat.getBlockSize()) {
                        fs.delete(tmpPath, false);
                    } else {
                        fs.rename(tmpPath, file.suffix(".index"));
                    }
                }
            }
        };
    }

    static {
        try {
            isLzopIndexSupported = null != LzopCodec.class.getMethod("createIndexedOutputStream", OutputStream.class, DataOutputStream.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

