/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);

    public static Counter getCounter(JobContext ctx, String group, String counter) {
        Counter c;
        if (ctx instanceof TaskInputOutputContext && (c = ((TaskInputOutputContext)ctx).getCounter(group, counter)) != null) {
            return c;
        }
        String name = group + ":" + counter;
        LOG.warn("Using a dummy counter for " + name + " because it does not already exist.");
        return new Counter(name, name){};
    }

    @Deprecated
    public static void setInputFormatClass(Configuration conf, String configKey, Class<?> clazz) {
        HadoopUtils.setClassConf(conf, configKey, clazz);
    }

    public static void setClassConf(Configuration conf, String configKey, Class<?> clazz) {
        String existingClass = conf.get(configKey);
        String className = clazz.getName();
        if (existingClass != null && !existingClass.equals(className)) {
            throw new RuntimeException("Already registered a different thriftClass for " + configKey + ". old: " + existingClass + " new: " + className);
        }
        conf.set(configKey, className);
    }
}

