/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.twitter.elephantbird.util.ThriftUtils;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;

public class TStructDescriptor {
    private static Map<Class<?>, TStructDescriptor> structMap = Maps.newHashMap();
    private List<Field> fields;
    private Class<? extends TBase<?, ?>> tClass;
    private boolean isUnion;

    public Class<? extends TBase<?, ?>> getThriftClass() {
        return this.tClass;
    }

    public TBase<?, ?> newThriftObject() throws TException {
        try {
            return this.tClass.newInstance();
        }
        catch (Exception e) {
            throw new TException((Throwable)e);
        }
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field getFieldAt(int idx) {
        return this.fields.get(idx);
    }

    public Object getFieldValue(int fieldIdx, TBase tObject) {
        Field field = this.fields.get(fieldIdx);
        try {
            if (this.isUnion && field.getFieldIdEnum() != ((TUnion)tObject).getSetField()) {
                return null;
            }
            return tObject.getFieldValue(field.getFieldIdEnum());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TStructDescriptor getInstance(Class<? extends TBase<?, ?>> tClass) {
        Map<Class<?>, TStructDescriptor> map = structMap;
        synchronized (map) {
            TStructDescriptor desc = structMap.get(tClass);
            if (desc == null) {
                desc = new TStructDescriptor();
                desc.tClass = tClass;
                structMap.put(tClass, desc);
                desc.build(tClass);
            }
            return desc;
        }
    }

    private TStructDescriptor() {
    }

    private void build(Class<? extends TBase<?, ?>> tClass) {
        Map fieldMap = FieldMetaData.getStructMetaDataMap(tClass);
        Object[] arr = new Field[fieldMap.size()];
        this.isUnion = TUnion.class.isAssignableFrom(tClass);
        int idx = 0;
        for (Map.Entry e : fieldMap.entrySet()) {
            arr[idx++] = new Field((TFieldIdEnum)e.getKey(), ((TFieldIdEnum)e.getKey()).getFieldName(), tClass, ((FieldMetaData)e.getValue()).valueMetaData);
        }
        this.fields = ImmutableList.copyOf((Object[])arr);
    }

    private static Map<String, TEnum> extractEnumMap(Class<? extends TEnum> enumClass) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TEnum e : enumClass.getEnumConstants()) {
            builder.put((Object)e.toString(), (Object)e);
        }
        return builder.build();
    }

    public static class Field {
        private final TFieldIdEnum fieldIdEnum;
        private final short fieldId;
        private final String fieldName;
        private final FieldValueMetaData field;
        private final Field listElemField;
        private final Field setElemField;
        private final Field mapKeyField;
        private final Field mapValueField;
        private final Map<String, TEnum> enumMap;
        private final Map<Integer, TEnum> enumIdMap;
        private final TStructDescriptor tStructDescriptor;
        private final boolean isBuffer_;

        private Field(TFieldIdEnum fieldIdEnum, String fieldName, Class<?> enclosingClass, FieldValueMetaData field) {
            this.fieldIdEnum = fieldIdEnum;
            this.fieldId = fieldIdEnum == null ? (short)1 : fieldIdEnum.getThriftFieldId();
            this.fieldName = fieldName;
            this.field = field;
            boolean simpleField = field.getClass() == FieldValueMetaData.class;
            this.listElemField = !simpleField && field instanceof ListMetaData ? new Field(null, fieldName + "_list_elem", null, ((ListMetaData)field).elemMetaData) : null;
            if (!simpleField && field instanceof MapMetaData) {
                this.mapKeyField = new Field(null, fieldName + "_map_key", null, ((MapMetaData)field).keyMetaData);
                this.mapValueField = new Field(null, fieldName + "_map_value", null, ((MapMetaData)field).valueMetaData);
            } else {
                this.mapKeyField = null;
                this.mapValueField = null;
            }
            this.setElemField = !simpleField && field instanceof SetMetaData ? new Field(null, fieldName + "_set_elem", null, ((SetMetaData)field).elemMetaData) : null;
            if (!simpleField && field instanceof EnumMetaData) {
                this.enumMap = TStructDescriptor.extractEnumMap(((EnumMetaData)field).enumClass);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (TEnum e : this.enumMap.values()) {
                    builder.put((Object)e.getValue(), (Object)e);
                }
                this.enumIdMap = builder.build();
            } else {
                this.enumMap = null;
                this.enumIdMap = null;
            }
            this.tStructDescriptor = field.isStruct() ? TStructDescriptor.getInstance(((StructMetaData)field).structClass) : null;
            this.isBuffer_ = field.type == 11 && enclosingClass != null ? ThriftUtils.getFieldType(enclosingClass, fieldName) != String.class : false;
        }

        public short getFieldId() {
            return this.fieldId;
        }

        public byte getType() {
            return this.field.type;
        }

        public TFieldIdEnum getFieldIdEnum() {
            return this.fieldIdEnum;
        }

        public FieldValueMetaData getField() {
            return this.field;
        }

        public boolean isBuffer() {
            return this.isBuffer_;
        }

        public boolean isList() {
            return this.listElemField != null;
        }

        public Field getListElemField() {
            return this.listElemField;
        }

        public boolean isSet() {
            return this.setElemField != null;
        }

        public Field getSetElemField() {
            return this.setElemField;
        }

        public boolean isMap() {
            return this.mapKeyField != null;
        }

        public Field getMapKeyField() {
            return this.mapKeyField;
        }

        public Field getMapValueField() {
            return this.mapValueField;
        }

        public boolean isStruct() {
            return this.tStructDescriptor != null;
        }

        public TStructDescriptor gettStructDescriptor() {
            return this.tStructDescriptor;
        }

        public boolean isEnum() {
            return this.enumMap != null;
        }

        public TEnum getEnumValueOf(String name) {
            return this.enumMap.get(name);
        }

        public TEnum getEnumValueOf(int id) {
            return this.enumIdMap.get(id);
        }

        public String getName() {
            return this.fieldName;
        }

        public short getId() {
            return this.fieldId;
        }
    }
}

