/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufBlockWriter;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.LzoBinaryBlockRecordWriter;
import com.twitter.elephantbird.mapreduce.output.LzoOutputFormat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class LzoProtobufBlockOutputFormat<M extends Message>
extends LzoOutputFormat<M, ProtobufWritable<M>> {
    protected TypeRef<M> typeRef_;

    protected void setTypeRef(TypeRef<M> typeRef) {
        this.typeRef_ = typeRef;
    }

    public LzoProtobufBlockOutputFormat() {
    }

    public LzoProtobufBlockOutputFormat(TypeRef<M> typeRef) {
        this.typeRef_ = typeRef;
    }

    public static <M extends Message> void setClassConf(Class<M> protoClass, Configuration jobConf) {
        Protobufs.setClassConf(jobConf, LzoProtobufBlockOutputFormat.class, protoClass);
    }

    public static <M extends Message> LzoProtobufBlockOutputFormat<M> newInstance(TypeRef<M> typeRef) {
        return new LzoProtobufBlockOutputFormat<M>(typeRef);
    }

    public RecordWriter<M, ProtobufWritable<M>> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        if (this.typeRef_ == null) {
            this.typeRef_ = Protobufs.getTypeRef(job.getConfiguration(), LzoProtobufBlockOutputFormat.class);
        }
        return new LzoBinaryBlockRecordWriter(new ProtobufBlockWriter<M>(this.getOutputStream(job), this.typeRef_.getRawClass()));
    }
}

