/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class RawSequenceFileRecordReader
extends RecordReader<DataInputBuffer, DataInputBuffer> {
    public static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final DataOutputBuffer kobuf = new DataOutputBuffer(0x100000);
    private final DataOutputBuffer vobuf = new DataOutputBuffer(0x100000);
    private final DataInputBuffer kibuf = new DataInputBuffer();
    private final DataInputBuffer vibuf = new DataInputBuffer();
    private SequenceFile.Reader reader;
    private SequenceFile.ValueBytes vbytes;
    private long start;
    private long end;
    private boolean more;
    private boolean valueUncompressed;

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)inputSplit, (Object)"InputSplit is null");
        Preconditions.checkNotNull((Object)context, (Object)"TaskAttemptContext is null");
        Configuration conf = context.getConfiguration();
        FileSplit fileSplit = (FileSplit)inputSplit;
        Path path = fileSplit.getPath();
        this.reader = new SequenceFile.Reader(FileSystem.get((Configuration)conf), path, conf){

            public synchronized Class<?> getKeyClass() {
                return BytesWritable.class;
            }

            public synchronized Class<?> getValueClass() {
                return BytesWritable.class;
            }
        };
        this.vbytes = this.reader.createValueBytes();
        this.start = fileSplit.getStart();
        if (this.start > this.reader.getPosition()) {
            this.reader.sync(this.start);
        }
        this.start = this.reader.getPosition();
        this.end = fileSplit.getStart() + fileSplit.getLength();
        this.more = this.start < this.end;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.vbytes = null;
        this.end = 0L;
        this.start = 0L;
        this.more = false;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)this.reader);
        if (!this.more) {
            return false;
        }
        long pos = this.reader.getPosition();
        this.kobuf.reset();
        int recordLength = this.reader.nextRaw(this.kobuf, this.vbytes);
        if (recordLength < 0 || pos >= this.end && this.reader.syncSeen()) {
            this.more = false;
            return false;
        }
        this.valueUncompressed = false;
        return true;
    }

    public DataInputBuffer getCurrentKey() throws IOException, InterruptedException {
        if (!this.more) {
            return null;
        }
        this.kibuf.reset(this.kobuf.getData(), this.kobuf.getLength());
        return this.kibuf;
    }

    public DataInputBuffer getCurrentValue() throws IOException, InterruptedException {
        if (!this.more) {
            return null;
        }
        if (!this.valueUncompressed) {
            this.vobuf.reset();
            this.vbytes.writeUncompressedBytes((DataOutputStream)this.vobuf);
            this.valueUncompressed = true;
        }
        this.vibuf.reset(this.vobuf.getData(), this.vobuf.getLength());
        return this.vibuf;
    }

    public float getProgress() throws IOException, InterruptedException {
        if (this.end == this.start) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.reader.getPosition() - this.start) / (float)(this.end - this.start));
    }
}

