/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.util.HadoopUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class MapReduceInputFormatWrapper<K, V>
extends InputFormat<K, V> {
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.MapReduceInputFormatWrapper";
    protected org.apache.hadoop.mapred.InputFormat<K, V> realInputFormat;

    public static void setInputFormat(Class<?> realInputFormatClass, Job job) {
        job.setInputFormatClass(MapReduceInputFormatWrapper.class);
        HadoopUtils.setClassConf(job.getConfiguration(), CLASS_CONF_KEY, realInputFormatClass);
    }

    private void initInputFormat(Configuration conf) {
        if (this.realInputFormat == null) {
            this.realInputFormat = (org.apache.hadoop.mapred.InputFormat)ReflectionUtils.newInstance((Class)conf.getClass(CLASS_CONF_KEY, null, org.apache.hadoop.mapred.InputFormat.class), (Configuration)conf);
        }
    }

    public MapReduceInputFormatWrapper() {
    }

    public MapReduceInputFormatWrapper(org.apache.hadoop.mapred.InputFormat<K, V> realInputFormat) {
        this.realInputFormat = realInputFormat;
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initInputFormat(context.getConfiguration());
        return new RecordReaderWrapper<K, V>(this.realInputFormat);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException, InterruptedException {
        JobConf jobConf = (JobConf)context.getConfiguration();
        this.initInputFormat((Configuration)jobConf);
        org.apache.hadoop.mapred.InputSplit[] splits = this.realInputFormat.getSplits(jobConf, jobConf.getNumMapTasks());
        if (splits == null) {
            return null;
        }
        ArrayList<InputSplit> resultSplits = new ArrayList<InputSplit>(splits.length);
        for (org.apache.hadoop.mapred.InputSplit split : splits) {
            if (split.getClass() == org.apache.hadoop.mapred.FileSplit.class) {
                org.apache.hadoop.mapred.FileSplit mapredFileSplit = (org.apache.hadoop.mapred.FileSplit)split;
                resultSplits.add((InputSplit)new FileSplit(mapredFileSplit.getPath(), mapredFileSplit.getStart(), mapredFileSplit.getLength(), mapredFileSplit.getLocations()));
                continue;
            }
            resultSplits.add(new InputSplitWrapper(split));
        }
        return resultSplits;
    }

    private static class InputSplitWrapper
    extends InputSplit
    implements Writable {
        org.apache.hadoop.mapred.InputSplit realSplit;

        public InputSplitWrapper() {
        }

        public InputSplitWrapper(org.apache.hadoop.mapred.InputSplit realSplit) {
            this.realSplit = realSplit;
        }

        public long getLength() throws IOException {
            return this.realSplit.getLength();
        }

        public String[] getLocations() throws IOException {
            return this.realSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            Class<?> splitClass;
            String className = WritableUtils.readString((DataInput)in);
            try {
                splitClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
            this.realSplit = (org.apache.hadoop.mapred.InputSplit)ReflectionUtils.newInstance(splitClass, null);
            this.realSplit.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            WritableUtils.writeString((DataOutput)out, (String)this.realSplit.getClass().getName());
            this.realSplit.write(out);
        }
    }

    private static class RecordReaderWrapper<K, V>
    extends RecordReader<K, V> {
        private org.apache.hadoop.mapred.RecordReader<K, V> realReader;
        private org.apache.hadoop.mapred.InputFormat<K, V> realInputFormat;
        private K keyObj = null;
        private V valueObj = null;

        public RecordReaderWrapper(org.apache.hadoop.mapred.InputFormat<K, V> realInptuFormat) throws IOException {
            this.realInputFormat = realInptuFormat;
        }

        public void close() throws IOException {
            this.realReader.close();
        }

        public float getProgress() throws IOException {
            return this.realReader.getProgress();
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Object oldSplit = split.getClass() == FileSplit.class ? new org.apache.hadoop.mapred.FileSplit(((FileSplit)split).getPath(), ((FileSplit)split).getStart(), ((FileSplit)split).getLength(), split.getLocations()) : ((InputSplitWrapper)split).realSplit;
            final TaskInputOutputContext ctx = (TaskInputOutputContext)context;
            Reporter reporter = new Reporter(){

                public void progress() {
                    ctx.progress();
                }

                public void setStatus(String status) {
                    ctx.setStatus(status);
                }

                public void incrCounter(String group, String counter, long amount) {
                    ctx.getCounter(group, counter).increment(amount);
                }

                public void incrCounter(Enum<?> key, long amount) {
                    ctx.getCounter(key).increment(amount);
                }

                public org.apache.hadoop.mapred.InputSplit getInputSplit() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }

                public Counters.Counter getCounter(String group, String name) {
                    return (Counters.Counter)ctx.getCounter(group, name);
                }

                public Counters.Counter getCounter(Enum<?> name) {
                    return (Counters.Counter)ctx.getCounter(name);
                }
            };
            this.realReader = this.realInputFormat.getRecordReader(oldSplit, (JobConf)context.getConfiguration(), reporter);
            this.keyObj = this.realReader.createKey();
            this.valueObj = this.realReader.createValue();
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.keyObj;
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.valueObj;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            return this.realReader.next(this.keyObj, this.valueObj);
        }
    }
}

