/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.LineReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoJsonRecordReader
extends LzoRecordReader<LongWritable, MapWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoJsonRecordReader.class);
    private LineReader in_;
    private final LongWritable key_ = new LongWritable();
    private final Text currentLine_ = new Text();
    private final MapWritable value_ = new MapWritable();
    private final JSONParser jsonParser_ = new JSONParser();

    public synchronized void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public MapWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input, Configuration conf) throws IOException {
        this.in_ = new LineReader(input, conf);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        if (!atFirstRecord) {
            this.in_.readLine(new Text());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.value_.clear();
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int newSize = this.in_.readLine(this.currentLine_);
            if (newSize == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            if (!LzoJsonRecordReader.decodeLineToJson(this.jsonParser_, this.currentLine_, this.value_)) continue;
            return true;
        }
        return false;
    }

    public static boolean decodeLineToJson(JSONParser parser, Text line, MapWritable value) {
        try {
            JSONObject jsonObj = (JSONObject)parser.parse(line.toString());
            if (jsonObj != null) {
                for (Object key : jsonObj.keySet()) {
                    Text mapKey = new Text(key.toString());
                    Text mapValue = new Text();
                    if (jsonObj.get(key) != null) {
                        mapValue.set(jsonObj.get(key).toString());
                    }
                    value.put((Writable)mapKey, (Writable)mapValue);
                }
            } else {
                LOG.warn("Could not json-decode string: " + line);
                return false;
            }
            return true;
        }
        catch (ParseException e) {
            LOG.warn("Could not json-decode string: " + line, (Throwable)e);
            return false;
        }
        catch (NumberFormatException e) {
            LOG.warn("Could not parse field into number: " + line, (Throwable)e);
            return false;
        }
    }
}

