/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.collect.Lists;
import com.hadoop.compression.lzo.LzoIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoInputFormat.class);
    private final PathFilter hiddenPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith(".") && !name.startsWith("_");
        }
    };
    private final PathFilter visibleLzoFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith(".") && !name.startsWith("_") && name.endsWith(".lzo");
        }
    };

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List files = super.listStatus(job);
        ArrayList results = Lists.newArrayList();
        boolean recursive = job.getConfiguration().getBoolean("mapred.input.dir.recursive", false);
        for (FileStatus fileStatus : files) {
            FileSystem fs = fileStatus.getPath().getFileSystem(job.getConfiguration());
            this.addInputPath(results, fs, fileStatus, recursive);
        }
        LOG.debug("Total lzo input paths to process : " + results.size());
        return results;
    }

    protected void addInputPath(List<FileStatus> results, FileSystem fs, FileStatus pathStat, boolean recursive) throws IOException {
        Path path = pathStat.getPath();
        if (pathStat.isDir()) {
            if (recursive) {
                for (FileStatus stat : fs.listStatus(path, this.hiddenPathFilter)) {
                    this.addInputPath(results, fs, stat, recursive);
                }
            }
        } else if (this.visibleLzoFilter.accept(path)) {
            results.add(pathStat);
        }
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        try {
            FileSystem fs = filename.getFileSystem(context.getConfiguration());
            return fs.exists(filename.suffix(".index"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        List defaultSplits = super.getSplits(job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        Path prevFile = null;
        LzoIndex prevIndex = null;
        for (InputSplit genericSplit : defaultSplits) {
            LzoIndex index;
            FileSplit fileSplit = (FileSplit)genericSplit;
            Path file = fileSplit.getPath();
            if (file.equals(prevFile)) {
                index = prevIndex;
            } else {
                index = LzoIndex.readIndex((FileSystem)file.getFileSystem(job.getConfiguration()), (Path)file);
                prevFile = file;
                prevIndex = index;
            }
            if (index == null) {
                throw new IOException("Index not found for " + file);
            }
            if (index.isEmpty()) {
                result.add((InputSplit)fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long lzoStart = index.alignSliceStartToIndex(start, end);
            long lzoEnd = index.alignSliceEndToIndex(end, file.getFileSystem(job.getConfiguration()).getFileStatus(file).getLen());
            if (lzoStart == -1L || lzoEnd == -1L) continue;
            result.add((InputSplit)new FileSplit(file, lzoStart, lzoEnd - lzoStart, fileSplit.getLocations()));
            LOG.debug("Added LZO split for " + file + "[start=" + lzoStart + ", length=" + (lzoEnd - lzoStart) + "]");
        }
        return result;
    }
}

