/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.io.BinaryBlockReader;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoBinaryBlockRecordReader<M, W extends BinaryWritable<M>>
extends LzoRecordReader<LongWritable, W> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBinaryBlockRecordReader.class);
    private final LongWritable key_ = new LongWritable();
    private final W value_;
    private final TypeRef<M> typeRef_;
    boolean updatePosition = false;
    private final BinaryBlockReader<M> reader_;
    private Counter recordsReadCounter;
    private Counter recordErrorsCounter;

    public LzoBinaryBlockRecordReader(TypeRef<M> typeRef, BinaryBlockReader<M> reader, W binaryWritable) {
        this.value_ = binaryWritable;
        this.reader_ = reader;
        this.typeRef_ = typeRef;
    }

    public synchronized void close() throws IOException {
        if (this.reader_ != null) {
            this.reader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public W getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream input, Configuration conf) throws IOException {
        this.reader_.setInputStream(input);
    }

    @Override
    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        String group = "LzoBlocks of " + this.typeRef_.getRawClass().getName();
        this.recordsReadCounter = HadoopUtils.getCounter((JobContext)context, group, "Records Read");
        this.recordErrorsCounter = HadoopUtils.getCounter((JobContext)context, group, "Errors");
        super.initialize(genericSplit, context);
    }

    @Override
    protected void skipToNextSyncPoint(boolean atFirstRecord) throws IOException {
        LOG.debug("LzoProtobufBlockRecordReader.skipToNextSyncPoint called with atFirstRecord = " + atFirstRecord);
        this.updatePosition = !atFirstRecord;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (true) {
            if (this.pos_ > this.end_) {
                this.reader_.markNoMoreNewBlocks();
            }
            ((BinaryWritable)this.value_).set(null);
            this.errorTracker.incRecords();
            Throwable decodeException = null;
            try {
                if (!this.reader_.readNext((BinaryWritable<M>)this.value_)) {
                    return false;
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                decodeException = e;
            }
            if (this.updatePosition) {
                this.pos_ = this.getLzoFilePos();
                this.updatePosition = false;
            }
            this.key_.set(this.pos_);
            this.pos_ = this.getLzoFilePos();
            if (((BinaryWritable)this.value_).get() != null) {
                this.recordsReadCounter.increment(1L);
                return true;
            }
            this.errorTracker.incErrors(decodeException);
            this.recordErrorsCounter.increment(1L);
        }
    }
}

