/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.output;

import com.twitter.elephantbird.util.HadoopUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class DeprecatedOutputFormatWrapper<K, V>
implements org.apache.hadoop.mapred.OutputFormat<K, V> {
    protected OutputFormat<K, V> realOutputFormat;
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.DeprecatedOutputFormatWrapper";

    public DeprecatedOutputFormatWrapper() {
    }

    public DeprecatedOutputFormatWrapper(OutputFormat<K, V> mapreduceOutputFormat) {
        this.realOutputFormat = mapreduceOutputFormat;
    }

    public static void setOutputFormat(Class<?> realOutputFormatClass, JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedOutputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, realOutputFormatClass);
    }

    private void initOutputFormat(JobConf conf) {
        if (this.realOutputFormat == null) {
            this.realOutputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)conf.getClass(CLASS_CONF_KEY, null, OutputFormat.class), (Configuration)conf);
        }
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        this.initOutputFormat(job);
        try {
            this.realOutputFormat.checkOutputSpecs(new JobContext((Configuration)job, null));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public org.apache.hadoop.mapred.RecordWriter<K, V> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        this.initOutputFormat(job);
        return new RecordWriterWrapper<K, V>(this.realOutputFormat, job, name, progress);
    }

    private static class RecordWriterWrapper<K, V>
    implements org.apache.hadoop.mapred.RecordWriter<K, V> {
        private RecordWriter<K, V> realWriter;
        private TaskAttemptContext taskContext;

        RecordWriterWrapper(OutputFormat<K, V> realOutputFormat, JobConf jobConf, String name, Progressable progress) throws IOException {
            try {
                this.taskContext = new TaskInputOutputContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id")), null, null, (StatusReporter)progress){

                    public Object getCurrentKey() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }

                    public Object getCurrentValue() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }

                    public boolean nextKeyValue() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }
                };
                this.realWriter = realOutputFormat.getRecordWriter(this.taskContext);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void close(Reporter reporter) throws IOException {
            try {
                this.realWriter.close(this.taskContext);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public void write(K key, V value) throws IOException {
            try {
                this.realWriter.write(key, value);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }
}

