/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.protocol.types.IWtcpSendable;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class WtcpKeyValueList
extends Hashtable
implements IWtcpSendable,
IWtcpReceivable {
    public WtcpKeyValueList() {
    }

    public WtcpKeyValueList(Hashtable other) {
        Enumeration keys = other.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = other.get(key).toString();
            this.put(key, value);
        }
    }

    public WtcpKeyValueList(IWtcMemoryStream inputStream) {
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        short listCount = inputStream.readInt16();
        int dictCount = listCount / 2;
        for (int i = 0; i < dictCount; ++i) {
            String key = inputStream.readString();
            String value = inputStream.readString();
            this.put(key, value);
        }
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream) {
        outputStream.writeInt16((short)(this.size() * 2));
        Enumeration keys = this.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            outputStream.writeString(key);
            outputStream.writeString((String)this.get(key));
        }
    }

    @Override
    public String toString() {
        Enumeration keys = this.keys();
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)this.get(key);
            sb.append('\"').append(key).append('\"').append(':').append('\"').append(value).append('\"');
            if (!keys.hasMoreElements()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }
}

