/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt32;
import java.util.Enumeration;
import java.util.Hashtable;

public class WtcpChannelIdErrorDictionary
extends Hashtable
implements IWtcpReceivable {
    public boolean isAnySuccessful() {
        return this.contains(WtcpErrorCode.OK);
    }

    public WtcpChannelIdErrorDictionary() {
    }

    public WtcpChannelIdErrorDictionary(IWtcMemoryStream inputStream) {
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        int count = inputStream.readInt16();
        for (int i = 0; i < count; ++i) {
            WtcInt32 id = WtcInt32.valueOf(inputStream.readInt32(), true);
            WtcpErrorCode errorCode = new WtcpErrorCode(inputStream);
            this.put(id, errorCode);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Enumeration ids = this.keys();
        while (ids.hasMoreElements()) {
            WtcInt32 id = (WtcInt32)ids.nextElement();
            WtcpErrorCode errorCode = (WtcpErrorCode)this.get(id);
            sb.append("{id=").append(id).append(", error=").append(errorCode).append('}');
            if (!ids.hasMoreElements()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

