/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.types.IWtcpReceivable;
import com.twistpair.wave.thinclient.protocol.types.WtcpAddressBookInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpList;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import java.util.Enumeration;
import java.util.Random;

public class WtcpAddressBookInfoList
extends WtcpList
implements IWtcpReceivable {
    public static final short VERSION = 1;
    public static final WtcpAddressBookInfoList FAKE = new WtcpAddressBookInfoList();

    private static String randomName(Random rand, int lengthFirst, int lengthLast) {
        int i;
        String data = "qwertyuiopasdfghjklzxcvbnm";
        int dataLength = "qwertyuiopasdfghjklzxcvbnm".length();
        StringBuffer sb = new StringBuffer(lengthFirst + 1 + lengthLast);
        sb.append(String.valueOf("qwertyuiopasdfghjklzxcvbnm".charAt(rand.nextInt(dataLength))).toUpperCase());
        for (i = 1; i < lengthFirst; ++i) {
            sb.append("qwertyuiopasdfghjklzxcvbnm".charAt(rand.nextInt(dataLength)));
        }
        sb.append(' ');
        sb.append(String.valueOf("qwertyuiopasdfghjklzxcvbnm".charAt(rand.nextInt(dataLength))).toUpperCase());
        for (i = 1; i < lengthLast; ++i) {
            sb.append("qwertyuiopasdfghjklzxcvbnm".charAt(rand.nextInt(dataLength)));
        }
        String name = sb.toString();
        return name;
    }

    public WtcpAddressBookInfoList() {
        super(WtcpAddressBookInfo.class);
    }

    public WtcpAddressBookInfoList(IWtcMemoryStream inputStream) {
        this();
        this.loadNetworkToHostOrder(inputStream);
    }

    @Override
    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream) {
        int count = inputStream.readInt16();
        for (int i = 0; i < count; ++i) {
            WtcpAddressBookInfo addressBookInfo = new WtcpAddressBookInfo(inputStream);
            this.addElement(addressBookInfo);
        }
    }

    @Override
    public String toString() {
        Enumeration elements = this.elements();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements()) {
            WtcpAddressBookInfo element = (WtcpAddressBookInfo)elements.nextElement();
            sb.append(element);
            if (!elements.hasMoreElements()) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    static {
        Random rand = new Random();
        for (int i = 0; i < 300; ++i) {
            String id = String.valueOf(i);
            int lengthFirst = 4 + rand.nextInt(3) - rand.nextInt(2);
            int lengthLast = 6 + rand.nextInt(4) - rand.nextInt(3);
            String name = WtcpAddressBookInfoList.randomName(rand, lengthFirst, lengthLast).trim();
            String type = String.valueOf(rand.nextInt(4));
            String phoneNumber = "555-222-" + String.valueOf(1000 + i);
            FAKE.addElement(new WtcpAddressBookInfo(id, name, type, phoneNumber));
        }
    }
}

