/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol.headers;

import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.IWtcpSubHeader;
import com.twistpair.wave.thinclient.util.CRC16Platform;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcpControlHeader
extends IWtcpSubHeader {
    public static final int SIZE = 8;
    public static final int SEQUENCE_NUMBER_BITS = 16;
    public static final int TRANSACTION_ID_NUMBER_BITS = 16;
    public static final int TRANSACTION_ID_MAX = 65535;
    public static final int OFFSET_START_CRC_CALCULATION = 6;
    public int crc;
    public int sequenceNumber;
    public WtcpVersionedOpCode verOpCode;
    public int transactionId;

    public static int getNextTransactionId(int lastTransactionId) {
        return ++lastTransactionId % 65535;
    }

    @Override
    public int getOffset() {
        return 4;
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public int getSequenceNumberBits() {
        return 16;
    }

    @Override
    public int getMessageType() {
        return 4;
    }

    public WtcpControlHeader() {
        this(new WtcpVersionedOpCode());
    }

    public WtcpControlHeader(WtcpVersionedOpCode verOpCode) {
        this(0, 0, verOpCode);
    }

    public WtcpControlHeader(int crc, int sequenceNumber, int opType, int opCode) {
        this(crc, sequenceNumber, new WtcpVersionedOpCode(opType, opCode));
    }

    public WtcpControlHeader(int crc, int sequenceNumber, WtcpVersionedOpCode verOpCode) {
        if (verOpCode == null) {
            throw new IllegalArgumentException("verOpCode cannot be null");
        }
        this.crc = crc;
        this.sequenceNumber = sequenceNumber;
        this.verOpCode = verOpCode;
        this.transactionId = 0;
    }

    public WtcpControlHeader(IWtcMemoryStream buffer) {
        super(buffer);
    }

    public int calculateCrc(byte[] buffer, int length) {
        return CRC16Platform.update(buffer, 6, length - 6) ^ 0xFFFF;
    }

    @Override
    public void dumpHostToNetworkOrder(IWtcMemoryStream buffer) {
        super.dumpHostToNetworkOrder(buffer);
        buffer.writeUInt16(this.crc);
        buffer.writeUInt16(this.sequenceNumber);
        this.verOpCode.dumpHostToNetworkOrder(buffer);
        buffer.writeUInt16(this.transactionId);
    }

    @Override
    public boolean loadNetworkToHostOrder(IWtcMemoryStream buffer) {
        if (!super.loadNetworkToHostOrder(buffer)) {
            return false;
        }
        this.crc = buffer.readUInt16();
        this.sequenceNumber = buffer.readUInt16();
        this.verOpCode.loadNetworkToHostOrder(buffer);
        this.transactionId = buffer.readUInt16();
        return true;
    }

    @Override
    public void reset() {
        this.transactionId = 0;
        this.sequenceNumber = 0;
        this.crc = 0;
        if (this.verOpCode == null) {
            this.verOpCode = new WtcpVersionedOpCode();
        } else {
            this.verOpCode.reset();
        }
    }

    @Override
    public String toString(char format) {
        format = Character.toLowerCase(format);
        StringBuffer sb = new StringBuffer().append('{');
        switch (format) {
            case 'd': {
                sb.append("c=").append(WtcString.formatNumber(this.crc, 5)).append(",s=").append(WtcString.formatNumber(this.sequenceNumber, 5)).append(",o=").append(this.verOpCode.toString(format)).append(",t=").append(WtcString.formatNumber(this.transactionId, 5));
                break;
            }
            default: {
                sb.append("c=0x").append(WtcString.toHexString(this.crc, 2)).append(",s=0x").append(WtcString.toHexString(this.sequenceNumber, 2)).append(",o=").append(this.verOpCode.toString(format)).append(",t=0x").append(WtcString.toHexString(this.transactionId, 2));
            }
        }
        return sb.append('}').toString();
    }

    public int getOpType() {
        return this.verOpCode.getOpType();
    }

    public int getOpCode() {
        return this.verOpCode.getOpCode();
    }

    public boolean isRequest() {
        return this.getOpType() == 1;
    }

    public boolean isResponse() {
        return this.getOpType() == 2;
    }

    public boolean isUnsolicited() {
        return this.getOpType() == 3;
    }

    public boolean isError() {
        return this.getOpType() == 4;
    }

    public static class WtcpVersionedOpCode {
        public static final int CURRENT_VERSION = 1;
        private int ushort0;

        public int getVersion() {
            return ((this.ushort0 & 0xE000) >> 13) + 1;
        }

        public void setVersion(int value) {
            int mask = 57344;
            this.ushort0 = this.ushort0 & ~mask | value - 1 << 13 & mask;
        }

        public int getOpType() {
            return (this.ushort0 & 0x1C00) >> 10;
        }

        public void setOpType(int value) {
            int mask = 7168;
            this.ushort0 = this.ushort0 & ~mask | (byte)value << 10 & mask;
        }

        public int getOpCode() {
            return (this.ushort0 & 0x3FF) >> 0;
        }

        public void setOpCode(int value) {
            int mask = 1023;
            this.ushort0 = this.ushort0 & ~mask | value << 0 & mask;
        }

        protected WtcpVersionedOpCode() {
            this.reset();
        }

        public WtcpVersionedOpCode(int opType, int opCode) {
            this(1, opType, opCode);
        }

        protected WtcpVersionedOpCode(int version, int opType, int opCode) {
            this.setVersion(version);
            this.setOpType(opType);
            this.setOpCode(opCode);
        }

        public void dumpHostToNetworkOrder(IWtcMemoryStream buffer) {
            buffer.writeUInt16(this.ushort0);
        }

        public void loadNetworkToHostOrder(IWtcMemoryStream buffer) {
            this.ushort0 = buffer.readUInt16();
        }

        public void reset() {
            this.ushort0 = 0;
        }

        public String toString() {
            return this.toString('x');
        }

        public String toString(char format) {
            format = Character.toLowerCase(format);
            return new StringBuffer().append('{').append("v=").append(WtcString.formatNumber(this.getVersion(), 1)).append(',').append("t=").append(WtcpConstants.WtcpOpType.toString(this.getOpType(), format)).append(",c=").append(WtcpConstants.WtcpOpCode.toString(this.getOpCode(), format)).append('}').toString();
        }
    }
}

