/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.protocol;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.headers.IWtcpSubHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpHeader;
import com.twistpair.wave.thinclient.protocol.headers.WtcpMediaHeader;
import com.twistpair.wave.thinclient.protocol.types.IWtcpSendable;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt16;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcInt8;
import com.twistpair.wave.thinclient.util.WtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcScalar;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.util.WtcUInt16;
import com.twistpair.wave.thinclient.util.WtcUInt32;
import com.twistpair.wave.thinclient.util.WtcUInt8;
import junit.framework.Assert;

public class WtcpMessage {
    private static final String TAG = WtcLog.TAG(WtcpMessage.class);
    public final IWtcMemoryStream stream = new WtcMemoryStream();
    private final WtcpHeader header = new WtcpHeader();
    private final WtcpControlHeader subHeaderControl = new WtcpControlHeader();
    private final WtcpMediaHeader subHeaderMedia = new WtcpMediaHeader();

    protected WtcpMessage() {
        this.reset();
    }

    public String toString() {
        return this.toString('a');
    }

    public String toString(char format) {
        format = Character.toLowerCase(format);
        byte[] buffer = this.stream.getBuffer();
        int length = this.stream.getLength();
        int headerSize = this.header.getSize();
        StringBuffer sb = new StringBuffer();
        sb.append("{h");
        if (this.header == null) {
            sb.append("=NULL");
        } else {
            sb.append('(').append(headerSize).append(")=").append(this.header.toString(format));
            int payloadOffset = headerSize;
            int temp = this.stream.getPosition();
            switch (this.header.getMessageType()) {
                case 4: {
                    WtcpControlHeader controlHeader = (WtcpControlHeader)this.getSubHeader();
                    sb.append(",c");
                    if (controlHeader == null) {
                        sb.append("=NULL");
                        break;
                    }
                    headerSize = controlHeader.getSize();
                    sb.append('(').append(headerSize).append(")=").append(controlHeader.toString(format));
                    payloadOffset += headerSize;
                    break;
                }
                case 5: {
                    WtcpMediaHeader mediaHeader = (WtcpMediaHeader)this.getSubHeader();
                    sb.append(",m");
                    if (mediaHeader == null) {
                        sb.append("=NULL");
                    } else {
                        headerSize = mediaHeader.getSize();
                        sb.append('(').append(headerSize).append(")=").append(mediaHeader.toString(format));
                        payloadOffset += headerSize;
                    }
                    length = Math.min(payloadOffset + 16, length);
                }
            }
            this.stream.setPosition(temp);
            int payloadLength = length - payloadOffset;
            sb.append(",p");
            if (payloadLength == 0) {
                sb.append("=NULL");
            } else {
                sb.append('(').append(payloadLength).append(")=");
                if (format != 'a' && format != 'd') {
                    sb.append(WtcString.toHexString(buffer, payloadOffset, payloadLength, true));
                } else {
                    block8: for (int i = payloadOffset; i < length; ++i) {
                        switch (format) {
                            case 'a': {
                                byte b = buffer[i];
                                if (32 <= b && b < 127) {
                                    if (b == 92) {
                                        sb.append("\\\\");
                                        continue block8;
                                    }
                                    sb.append(WtcString.getString(buffer, i, 1));
                                    continue block8;
                                }
                                sb.append('\\').append(b);
                                continue block8;
                            }
                            case 'd': {
                                if (i != payloadOffset) {
                                    sb.append(' ');
                                }
                                sb.append(' ').append(WtcString.formatNumber(buffer[i], 3));
                            }
                        }
                    }
                }
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public void dumpHeaderHostToNetworkOrder() {
        this.header.dumpHostToNetworkOrder(this.stream);
    }

    public boolean getHasHeader() {
        return this.stream.getPosition() >= 4;
    }

    public boolean getHasSubHeader() {
        return this.getSubHeader() != null;
    }

    public byte getMessageType() {
        return this.header.getMessageType();
    }

    public void setMessageType(byte messageType) {
        this.header.setMessageType(messageType);
    }

    public boolean getIsMessageType(int messageType) {
        return this.getHasHeader() && this.getMessageType() == messageType;
    }

    public boolean getShouldBeCrypted() {
        return this.getIsMessageType(4) || this.getIsMessageType(5);
    }

    public int reset() {
        this.stream.setPosition(0);
        this.stream.setLength(0);
        this.stream.setLength(4);
        return this.stream.getLength();
    }

    public WtcpHeader getHeader() {
        return this.header;
    }

    public void setHeader(WtcpHeader value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.stream.setLength(0);
        this.header.copyFrom(value);
    }

    public IWtcpSubHeader getSubHeader() {
        IWtcpSubHeader subHeader = null;
        switch (this.getMessageType()) {
            case 4: {
                subHeader = this.subHeaderControl;
                break;
            }
            case 5: {
                subHeader = this.subHeaderMedia;
            }
        }
        if (subHeader != null && this.stream.getLength() >= subHeader.getPayloadOffset()) {
            subHeader.loadNetworkToHostOrder(this.stream);
            return subHeader;
        }
        return null;
    }

    public void setSubHeader(IWtcpSubHeader value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        value.dumpHostToNetworkOrder(this.stream);
        Assert.assertEquals((String)"buffer.getPosition() != value.getOffsetPayload()", (int)this.stream.getPosition(), (int)value.getPayloadOffset());
        this.header.setMessageType(value.getMessageType());
        this.header.setPayloadLength(this.stream.getLength() - 4);
    }

    public void payloadSet(byte[] buffer, int offset, int count) {
        IWtcpSubHeader subHeader = this.getSubHeader();
        this.stream.setPosition(subHeader == null ? this.header.getPayloadOffset() : subHeader.getPayloadOffset());
        this.stream.write(buffer, offset, count);
    }

    public void payloadAppend(Object[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.payloadAppend(values[i]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void payloadAppend(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("payloadAppend: null values are not allowed; try using a \"EMPTY\" property");
        }
        if (value instanceof IWtcpSendable) {
            ((IWtcpSendable)value).dumpHostToNetworkOrder(this.stream);
            return;
        } else if (value instanceof IWtcMemoryStream) {
            IWtcMemoryStream stream = (IWtcMemoryStream)value;
            byte[] buffer = stream.getBuffer();
            int offset = stream.getPosition();
            int count = stream.getLength() - offset;
            this.stream.write(buffer, offset, count);
            return;
        } else if (value instanceof String) {
            this.stream.writeString((String)value);
            return;
        } else {
            if (!(value instanceof WtcScalar)) throw new IllegalArgumentException("unhandled type");
            if (value instanceof WtcInt8) {
                this.stream.writeInt8(((WtcInt8)value).value);
                return;
            } else if (value instanceof WtcUInt8) {
                this.stream.writeUInt8(((WtcUInt8)value).value);
                return;
            } else if (value instanceof WtcInt16) {
                this.stream.writeInt16(((WtcInt16)value).value);
                return;
            } else if (value instanceof WtcUInt16) {
                this.stream.writeUInt16(((WtcUInt16)value).value);
                return;
            } else if (value instanceof WtcInt32) {
                this.stream.writeInt32(((WtcInt32)value).value);
                return;
            } else {
                if (!(value instanceof WtcUInt32)) throw new IllegalArgumentException("unhandled WtcScalar type");
                this.stream.writeUInt32(((WtcUInt32)value).value);
            }
        }
    }
}

