/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.net;

import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcInetSocketAddressPlatform;
import com.twistpair.wave.thinclient.net.WtcNetworkExceptionPlatform;
import com.twistpair.wave.thinclient.net.WtcSocket;
import java.io.IOException;
import java.net.Socket;

public class WtcSocketPlatform
extends Socket
implements WtcSocket {
    private static final String TAG = WtcLog.TAG(WtcSocketPlatform.class);
    private WtcInetSocketAddressPlatform remoteAddress = null;

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void connect(WtcInetSocketAddressPlatform remoteAddress, int timeoutMs) throws IOException {
        this.connect(remoteAddress, timeoutMs, null);
    }

    @Override
    public void connect(WtcInetSocketAddressPlatform remoteAddress, int timeoutMs, WtcInetSocketAddressPlatform localAddress) throws IOException {
        try {
            if (localAddress != null) {
                try {
                    WtcLog.debug(TAG, "+bind(" + localAddress + ")");
                    super.bind(localAddress);
                    WtcLog.debug(TAG, "-bind(" + localAddress + ")");
                }
                catch (IOException e) {
                    WtcLog.error(TAG, "-bind(" + localAddress + ")", e);
                    throw e;
                }
            }
            super.connect(remoteAddress, timeoutMs);
            this.remoteAddress = remoteAddress;
        }
        catch (IOException e2) {
            WtcNetworkExceptionPlatform e2;
            if (WtcNetworkExceptionPlatform.isUnreachable(e2)) {
                e2 = new WtcNetworkExceptionPlatform.WtcNetworkUnreachableException(remoteAddress, (Exception)e2);
            } else if (WtcNetworkExceptionPlatform.isUnknownHostException(e2)) {
                e2 = new WtcNetworkExceptionPlatform.WtcNetworkUnknownHostException(remoteAddress, (Exception)e2);
            }
            throw e2;
        }
    }

    @Override
    public WtcInetSocketAddressPlatform getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public void shutdown() {
        try {
            super.shutdownInput();
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("transport endpoint is not connected")) {
                WtcLog.warn(TAG, "shutdownInput(); // ignore: " + e.toString());
            }
            WtcLog.error(TAG, "shutdownInput(); // ignore", e);
        }
        try {
            super.shutdownOutput();
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase().contains("transport endpoint is not connected")) {
                WtcLog.warn(TAG, "shutdownOutput(); // ignore: " + e.toString());
            }
            WtcLog.error(TAG, "shutdownOutput(); // ignore", e);
        }
    }
}

