/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.media;

import android.media.AudioTrack;
import android.os.Process;
import com.twistpair.wave.thinclient.logging.WtcLog;
import java.io.IOException;

public abstract class AudioPlayer
implements Runnable {
    private static final String TAG = WtcLog.TAG(AudioPlayer.class);
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final int mAudioStreamType;
    private final int mAudioSampleRate;
    private final int mAudioChannelConfig;
    private final int mAudioEncodingFormat;

    public AudioPlayer(int audioStreamType, int audioSampleRate, int audioChannelConfig, int audioEncodingFormat) {
        this.mAudioStreamType = audioStreamType;
        this.mAudioSampleRate = audioSampleRate;
        this.mAudioChannelConfig = audioChannelConfig;
        this.mAudioEncodingFormat = audioEncodingFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findMinBufferSizeInBytes(int audioStreamType, int audioSampleRate, int audioChannelConfig, int audioEncodingFormat, int maxMultiplier) throws IllegalArgumentException {
        WtcLog.debug(TAG, "audioStreamType=" + audioStreamType);
        WtcLog.debug(TAG, "audioSampleRate=" + audioSampleRate);
        WtcLog.debug(TAG, "audioChannelConfig=" + audioChannelConfig);
        WtcLog.debug(TAG, "audioEncodingFormat=" + audioEncodingFormat);
        int minBufferSize = AudioTrack.getMinBufferSize((int)audioSampleRate, (int)audioChannelConfig, (int)audioEncodingFormat);
        if (minBufferSize == -2 || minBufferSize == -1) {
            throw new IllegalArgumentException("getMinBufferSize(...)");
        }
        WtcLog.info(TAG, "minBufferSize=" + minBufferSize);
        for (int i = 1; i < maxMultiplier; ++i) {
            int bufferSize = minBufferSize * i;
            WtcLog.info(TAG, "Trying bufferSize=" + bufferSize + " (" + minBufferSize + " * " + i + ")");
            AudioTrack audioTrack = null;
            try {
                audioTrack = new AudioTrack(audioStreamType, audioSampleRate, audioChannelConfig, audioEncodingFormat, bufferSize, 1);
                if (audioTrack.getState() != 1) continue;
                WtcLog.info(TAG, "Found bufferSize=" + bufferSize + " (" + minBufferSize + " * " + i + ")");
                int n = bufferSize;
                return n;
            }
            catch (IllegalArgumentException e) {
                WtcLog.warn(TAG, "findMinBufferSize - IllegalArgumentException", e);
                continue;
            }
            finally {
                if (audioTrack != null) {
                    audioTrack.release();
                    audioTrack = null;
                }
            }
        }
        throw new IllegalArgumentException("Failed to initialize AudioTrack with bufferSize <= " + maxMultiplier + " * minBufferSize=" + minBufferSize);
    }

    protected abstract void onAudioPlayerStarted(int var1);

    protected abstract int onAudioPlayerGetBuffer(short[] var1) throws InterruptedException;

    protected abstract void onAudioPlayerStopped(Exception var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block30: {
            Exception error;
            AudioTrack audioTrack;
            block27: {
                String detailMessage;
                int length;
                audioTrack = null;
                error = null;
                WtcLog.info(TAG, "+run()");
                int minBufferSizeInBytes = AudioPlayer.findMinBufferSizeInBytes(this.mAudioStreamType, this.mAudioSampleRate, this.mAudioChannelConfig, this.mAudioEncodingFormat, 10);
                WtcLog.info(TAG, "+audioTrack = new AudioTrack(..., " + minBufferSizeInBytes + ", ...)");
                audioTrack = new AudioTrack(this.mAudioStreamType, this.mAudioSampleRate, this.mAudioChannelConfig, this.mAudioEncodingFormat, minBufferSizeInBytes, 1);
                WtcLog.info(TAG, "-audioTrack = new AudioTrack(..., " + minBufferSizeInBytes + ", ...)");
                short[] buffer = new short[minBufferSizeInBytes];
                this.onAudioPlayerStarted(buffer.length);
                Process.setThreadPriority((int)-16);
                audioTrack.play();
                do {
                    if ((length = this.onAudioPlayerGetBuffer(buffer)) <= 0) continue;
                    length = audioTrack.write(buffer, 0, length);
                } while (length > 0);
                switch (length) {
                    case 0: {
                        WtcLog.warn(TAG, "run: length == 0; // ending playback");
                        detailMessage = null;
                        break;
                    }
                    case -1: {
                        detailMessage = "AudioTrack.ERROR(" + length + ")";
                        break;
                    }
                    case -2: {
                        detailMessage = "AudioTrack.ERROR_BAD_VALUE(" + length + ")";
                        break;
                    }
                    case -3: {
                        detailMessage = "AudioTrack.ERROR_INVALID_OPERATION(" + length + ")";
                        break;
                    }
                    default: {
                        detailMessage = "AudioTrack.ERROR UNKNOWN(" + length + ")";
                    }
                }
                if (detailMessage != null) {
                    WtcLog.error(TAG, detailMessage);
                    throw new IOException(detailMessage);
                }
                if (audioTrack == null) break block27;
                try {
                    audioTrack.flush();
                    if (audioTrack.getState() == 1) {
                        audioTrack.stop();
                    }
                    audioTrack.release();
                    audioTrack = null;
                }
                catch (Exception e) {
                    WtcLog.error(TAG, "run: EXCEPTION track.flush()/stop()/release()", e);
                }
            }
            this.onAudioPlayerStopped(error);
            WtcLog.info(TAG, "-run()");
            break block30;
            catch (InterruptedException e) {
                block28: {
                    WtcLog.warn(TAG, "run: InterruptedException; ignoring");
                    if (audioTrack == null) break block28;
                    try {
                        audioTrack.flush();
                        if (audioTrack.getState() == 1) {
                            audioTrack.stop();
                        }
                        audioTrack.release();
                        audioTrack = null;
                    }
                    catch (Exception e2) {
                        WtcLog.error(TAG, "run: EXCEPTION track.flush()/stop()/release()", e2);
                    }
                }
                this.onAudioPlayerStopped(error);
                WtcLog.info(TAG, "-run()");
            }
            catch (Exception e2) {
                block29: {
                    WtcLog.error(TAG, "run: EXCEPTION", e2);
                    error = e2;
                    if (audioTrack == null) break block29;
                    {
                        catch (Throwable throwable) {
                            if (audioTrack != null) {
                                try {
                                    audioTrack.flush();
                                    if (audioTrack.getState() == 1) {
                                        audioTrack.stop();
                                    }
                                    audioTrack.release();
                                    audioTrack = null;
                                }
                                catch (Exception e3) {
                                    WtcLog.error(TAG, "run: EXCEPTION track.flush()/stop()/release()", e3);
                                }
                            }
                            this.onAudioPlayerStopped(error);
                            WtcLog.info(TAG, "-run()");
                            throw throwable;
                        }
                    }
                    try {
                        audioTrack.flush();
                        if (audioTrack.getState() == 1) {
                            audioTrack.stop();
                        }
                        audioTrack.release();
                        audioTrack = null;
                    }
                    catch (Exception e4) {
                        WtcLog.error(TAG, "run: EXCEPTION track.flush()/stop()/release()", e4);
                    }
                }
                this.onAudioPlayerStopped(error);
                WtcLog.info(TAG, "-run()");
            }
        }
    }
}

