/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.logging;

import com.twistpair.wave.thinclient.logging.IWtcLogListener;
import com.twistpair.wave.thinclient.logging.WtcLogPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Vector;

public class WtcLog {
    private static boolean isEnabled = true;
    private static final Vector logListeners = new Vector();

    public static String TAG(Object o) {
        return WtcLog.TAG(o == null ? null : o.getClass());
    }

    public static String TAG(Class c) {
        return WtcString.getShortClassName(c);
    }

    public static void isEnabled(boolean enable) {
        isEnabled = enable;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(IWtcLogListener listener) {
        Vector vector = logListeners;
        synchronized (vector) {
            logListeners.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(IWtcLogListener listener) {
        Vector vector = logListeners;
        synchronized (vector) {
            logListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearListeners() {
        Vector vector = logListeners;
        synchronized (vector) {
            logListeners.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void println(String tag, int level, String msg, Throwable e) {
        if (isEnabled) {
            String preformatted = WtcLogPlatform.println(tag, level, msg, e);
            if (logListeners.size() > 0) {
                Vector vector = logListeners;
                synchronized (vector) {
                    for (int i = 0; i < logListeners.size(); ++i) {
                        if (preformatted != null) {
                            ((IWtcLogListener)logListeners.elementAt(i)).println(preformatted);
                            continue;
                        }
                        ((IWtcLogListener)logListeners.elementAt(i)).println(tag, level, msg, e);
                    }
                }
            }
        }
    }

    public static void verbose(String tag, String msg) {
        WtcLog.verbose(tag, msg, null);
    }

    public static void verbose(String tag, Throwable e) {
        WtcLog.verbose(tag, "Throwable", e);
    }

    public static void verbose(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 2, msg, e);
    }

    public static void debug(String tag, String msg) {
        WtcLog.debug(tag, msg, null);
    }

    public static void debug(String tag, Throwable e) {
        WtcLog.debug(tag, "Throwable", e);
    }

    public static void debug(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 3, msg, e);
    }

    public static void info(String tag, String msg) {
        WtcLog.info(tag, msg, null);
    }

    public static void info(String tag, Throwable e) {
        WtcLog.info(tag, "Throwable", e);
    }

    public static void info(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 4, msg, e);
    }

    public static void warn(String tag, String msg) {
        WtcLog.warn(tag, msg, null);
    }

    public static void warn(String tag, Throwable e) {
        WtcLog.warn(tag, "Throwable", e);
    }

    public static void warn(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 5, msg, e);
    }

    public static void error(String tag, String msg) {
        WtcLog.error(tag, msg, null);
    }

    public static void error(String tag, Throwable e) {
        WtcLog.error(tag, "Throwable", e);
    }

    public static void error(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 6, msg, e);
    }

    public static void fatal(String tag, String msg) {
        WtcLog.fatal(tag, msg, null);
    }

    public static void fatal(String tag, Throwable e) {
        WtcLog.fatal(tag, "Throwable", e);
    }

    public static void fatal(String tag, String msg, Throwable e) {
        WtcLog.println(tag, 0, msg, e);
    }
}

