/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import com.twistpair.wave.thinclient.logging.WtcLog;

public class WtcPayloadTransformerAes256Counter
implements WtcKexCryptoBase.IWtcPayloadTransformer {
    private static final String TAG = WtcLog.TAG(WtcPayloadTransformerAes256Counter.class);
    private static final int BLOCK_LENGTH = 16;
    protected WtcKexCryptoBase.IWtcTransformer[] transformers;
    protected byte[] iv;

    @Override
    public int getBlockLength() {
        return 16;
    }

    @Override
    public void initialize(WtcKexCryptoBase.IWtcTransformer[] transformers, byte[] iv) throws IllegalArgumentException {
        if (transformers == null || transformers.length == 0) {
            throw new IllegalArgumentException("transformers must not be null or empty");
        }
        for (int i = 0; i < transformers.length; ++i) {
            if (transformers[i] instanceof WtcCryptoUtilPlatform.WtcEncryptorAes256Ecb) continue;
            throw new IllegalArgumentException("transformers[" + i + "] must be instance of WtcEncryptorAes256Ecb");
        }
        this.transformers = transformers;
        if (iv == null || iv.length != this.getBlockLength()) {
            throw new IllegalArgumentException("iv.length != getBlockLength(): " + this.getBlockLength());
        }
        this.iv = iv;
    }

    @Override
    public void transformPayload(long extendedSequenceNumber, byte[] messageBuffer, int payloadOffset, int payloadLength, byte[] workingBlockBuffer) throws WtcKexCryptoBase.WtcKexCryptoException {
        try {
            if (workingBlockBuffer == null || workingBlockBuffer.length != this.iv.length) {
                throw new IllegalArgumentException("workingBlockBuffer.length != iv.length: " + this.iv.length);
            }
            WtcKexCryptoBase.IWtcTransformer transformer = this.transformers[(int)(extendedSequenceNumber % (long)this.transformers.length)];
            int blockIndex = 0;
            while (payloadLength > 0) {
                workingBlockBuffer[0] = this.iv[0];
                workingBlockBuffer[1] = this.iv[1];
                workingBlockBuffer[2] = this.iv[2];
                workingBlockBuffer[3] = this.iv[3];
                workingBlockBuffer[4] = this.iv[4];
                workingBlockBuffer[5] = this.iv[5];
                workingBlockBuffer[6] = this.iv[6];
                workingBlockBuffer[7] = this.iv[7];
                workingBlockBuffer[8] = (byte)(this.iv[8] ^ (blockIndex & 0xFF000000) >> 24);
                workingBlockBuffer[9] = (byte)(this.iv[9] ^ (blockIndex & 0xFF0000) >> 16);
                workingBlockBuffer[10] = (byte)(this.iv[10] ^ (blockIndex & 0xFF00) >> 8);
                workingBlockBuffer[11] = (byte)(this.iv[11] ^ (blockIndex & 0xFF) >> 0);
                workingBlockBuffer[12] = (byte)((long)this.iv[12] ^ (extendedSequenceNumber & 0xFFFFFFFFFF000000L) >> 24);
                workingBlockBuffer[13] = (byte)((long)this.iv[13] ^ (extendedSequenceNumber & 0xFF0000L) >> 16);
                workingBlockBuffer[14] = (byte)((long)this.iv[14] ^ (extendedSequenceNumber & 0xFF00L) >> 8);
                workingBlockBuffer[15] = (byte)((long)this.iv[15] ^ (extendedSequenceNumber & 0xFFL) >> 0);
                transformer.transform(workingBlockBuffer, 0, workingBlockBuffer, 0);
                int transformLength = Math.min(payloadLength, 16);
                for (int transformOffset = 0; transformOffset < transformLength; ++transformOffset) {
                    int n = payloadOffset + transformOffset;
                    messageBuffer[n] = (byte)(messageBuffer[n] ^ workingBlockBuffer[transformOffset]);
                }
                payloadOffset += transformLength;
                payloadLength -= transformLength;
                ++blockIndex;
            }
        }
        catch (Exception e) {
            WtcLog.error(TAG, "EXCEPTION: transformPayload", e);
            throw new WtcKexCryptoBase.WtcKexCryptoException("transformPayload", e);
        }
    }
}

