/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient.kexcrypto;

import com.twistpair.wave.thinclient.kexcrypto.WtcKexCryptoBase;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class WtcCryptoUtilPlatform {
    protected static final String AES_ECB_PADDING_NONE = "AES/ECB/NoPadding";
    protected static final String HMAC_SHA256 = "HmacSHA256";
    protected static final String SHA256 = "SHA256";

    public static byte[] HMACSHA256(byte[] key, byte[] buffer) throws WtcKexCryptoBase.WtcKexCryptoException {
        return WtcCryptoUtilPlatform.HMACSHA256(key, buffer, 0, buffer.length);
    }

    public static byte[] HMACSHA256(byte[] key, byte[] buffer, int offset, int length) throws WtcKexCryptoBase.WtcKexCryptoException {
        SecretKeySpec signingKey = new SecretKeySpec(key, HMAC_SHA256);
        try {
            Mac mac = Mac.getInstance(signingKey.getAlgorithm());
            mac.init(signingKey);
            mac.update(buffer, offset, length);
            return mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("HMACSHA256(...)", e);
        }
        catch (InvalidKeyException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("HMACSHA256(...)", e);
        }
    }

    public static byte[] SHA256(byte[] buffer) throws WtcKexCryptoBase.WtcKexCryptoException {
        try {
            return MessageDigest.getInstance(SHA256).digest(buffer);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WtcKexCryptoBase.WtcKexCryptoException("SHA256(...)", e);
        }
    }

    public static int getRandomInt32() {
        SecureRandom random = new SecureRandom();
        return random.nextInt();
    }

    public static long getRandomInt64() {
        SecureRandom random = new SecureRandom();
        return random.nextLong();
    }

    public static byte[] getRandomBytes(int count) {
        byte[] bytes = new byte[count];
        SecureRandom random = new SecureRandom();
        random.nextBytes(bytes);
        return bytes;
    }

    public static class WtcEncryptorAes256Ecb
    extends WtcKexCryptoBase.WtcTransformerAes256EcbBase {
        private static final String TAG = WtcLog.TAG(WtcEncryptorAes256Ecb.class);
        private final Cipher encryptor;

        public WtcEncryptorAes256Ecb(byte[] key) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                this.encryptor = Cipher.getInstance(WtcCryptoUtilPlatform.AES_ECB_PADDING_NONE);
                SecretKeySpec aesKey = new SecretKeySpec(key, this.encryptor.getAlgorithm());
                this.encryptor.init(1, aesKey);
            }
            catch (NoSuchAlgorithmException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
            catch (NoSuchPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
            catch (InvalidKeyException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcEncryptorAes256Ecb(...)", e);
            }
        }

        @Override
        public byte[] transform(byte[] inBytes, int offset, int length) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                return this.encryptor.doFinal(inBytes, offset, length);
            }
            catch (IllegalBlockSizeException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
        }

        @Override
        public void transform(byte[] inBytes, int inOffset, byte[] outBytes, int outOffset) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                this.encryptor.doFinal(inBytes, inOffset, inBytes.length - inOffset, outBytes, outOffset);
            }
            catch (ShortBufferException e) {
                String rawIn = WtcString.toHexString(inBytes, 0, inBytes.length);
                String rawOut = WtcString.toHexString(outBytes, 0, outBytes.length);
                String message = "WtcEncryptorAes256Ecb.transform: encryptor.doFinal inOffset=" + inOffset + ", inBytes[" + inBytes.length + "]=" + rawIn + ", outOffset=" + outOffset + ", outBytes[" + outBytes.length + "]=" + rawOut;
                WtcLog.error(TAG, message, e);
                throw new WtcKexCryptoBase.WtcKexCryptoException(message, e);
            }
            catch (IllegalBlockSizeException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcEncryptorAes256Ecb.transform", e);
            }
        }
    }

    public static class WtcDecryptorAes256Ecb
    extends WtcKexCryptoBase.WtcTransformerAes256EcbBase {
        private static final String TAG = WtcLog.TAG(WtcDecryptorAes256Ecb.class);
        private final Cipher decryptor;

        public WtcDecryptorAes256Ecb(byte[] key) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                this.decryptor = Cipher.getInstance(WtcCryptoUtilPlatform.AES_ECB_PADDING_NONE);
                SecretKeySpec aesKey = new SecretKeySpec(key, this.decryptor.getAlgorithm());
                this.decryptor.init(2, aesKey);
            }
            catch (NoSuchAlgorithmException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
            catch (NoSuchPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
            catch (InvalidKeyException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("new WtcDecryptorAes256Ecb(...)", e);
            }
        }

        @Override
        public byte[] transform(byte[] inBytes, int offset, int length) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                return this.decryptor.doFinal(inBytes, offset, length);
            }
            catch (IllegalBlockSizeException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
        }

        @Override
        public void transform(byte[] inBytes, int inOffset, byte[] outBytes, int outOffset) throws WtcKexCryptoBase.WtcKexCryptoException {
            try {
                this.decryptor.doFinal(inBytes, inOffset, inBytes.length - inOffset, outBytes, outOffset);
            }
            catch (ShortBufferException e) {
                String rawIn = WtcString.toHexString(inBytes, 0, inBytes.length);
                String rawOut = WtcString.toHexString(outBytes, 0, outBytes.length);
                String message = "WtcEncryptorAes256Ecb.transform: encryptor.doFinal inOffset=" + inOffset + ", inBytes[" + inBytes.length + "]=" + rawIn + ", outOffset=" + outOffset + ", outBytes[" + outBytes.length + "]=" + rawOut;
                WtcLog.error(TAG, message, e);
                throw new WtcKexCryptoBase.WtcKexCryptoException(message, e);
            }
            catch (IllegalBlockSizeException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
            catch (BadPaddingException e) {
                throw new WtcKexCryptoBase.WtcKexCryptoException("WtcDecryptorAes256Ecb.transform", e);
            }
        }
    }
}

