/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocator;
import com.twistpair.wave.thinclient.WtcLocatorErrorCodes;
import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.WtcProxyInfo;
import com.twistpair.wave.thinclient.kexcrypto.WtcCryptoUtilPlatform;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.net.WtcNet;
import com.twistpair.wave.thinclient.net.WtcUri;
import com.twistpair.wave.thinclient.net.WtcUriPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import com.twistpair.wave.thinclient.util.WtcVersionString;
import java.io.IOException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WtcUpdate {
    private static final String TAG = WtcLog.TAG(WtcUpdate.class);
    protected final WtcVersionString updateVersion;
    protected final WtcUri updateUri;
    protected final boolean updateRequired;
    protected final boolean updateAvailable;

    protected WtcUpdate(Node softwareVersionInfoNode, WtcVersionString clientVersion) throws WtcUpdateException {
        NamedNodeMap attributes = softwareVersionInfoNode.getAttributes();
        if (attributes == null) {
            throw new WtcUpdateException("SoftwareVersionInfo node has no attributes");
        }
        String attrCurrVersion = attributes.getNamedItem("CurrVersion").getNodeValue();
        String attrInstallLocationURI = attributes.getNamedItem("InstallLocationURI").getNodeValue();
        String attrForceSoftwareUpdate = attributes.getNamedItem("ForceSoftwareUpdate").getNodeValue();
        this.updateVersion = new WtcVersionString(attrCurrVersion);
        this.updateUri = WtcUriPlatform.parse(attrInstallLocationURI);
        this.updateRequired = attrForceSoftwareUpdate.equals("Y") && !this.updateVersion.equals(clientVersion);
        this.updateAvailable = this.updateVersion.greaterThan(clientVersion) || this.updateRequired;
    }

    public WtcVersionString getVersion() {
        return this.updateVersion;
    }

    public WtcUri getUri() {
        return this.updateUri;
    }

    public boolean isRequired() {
        return this.updateRequired;
    }

    public boolean isAvailable() {
        return this.updateAvailable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{updateAvailable=").append(this.updateAvailable).append(",updateRequired=").append(this.updateRequired).append(",updateVersion=").append(this.updateVersion).append(",updateUri=\"").append(this.updateUri).append("\"}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WtcUpdate checkForUpdate(WtcProxyInfo proxy, String clientPackageCode, WtcVersionString clientVersion) throws IOException, WtcUpdateException {
        try {
            WtcUpdate update;
            Element xmlDoc;
            WtcLog.info(TAG, "+checkForUpdate(proxy=" + proxy + ", clientPackageCode=\"" + clientPackageCode + "\", clientVersion=" + clientVersion + ")");
            WtcUri uriUpdate = WtcUriPlatform.parse(proxy.getSoftwareVersionCheckURL());
            WtcUri.Builder builder = ((WtcUri)uriUpdate).buildUpon();
            builder.appendQueryParameter("pc", clientPackageCode);
            builder.appendQueryParameter("ver", clientVersion.toString());
            uriUpdate = builder.build();
            uriUpdate = WtcLocator.verifyQuery(uriUpdate, "nonce", WtcCryptoUtilPlatform.getRandomInt64());
            try {
                xmlDoc = WtcNet.makeRequestXml(uriUpdate);
            }
            catch (WtcLocatorException.WtcLocatorResponseInvalidException e) {
                throw new WtcUpdateException(uriUpdate, "makeRequestXml", e);
            }
            if (xmlDoc == null) {
                throw new WtcUpdateException(uriUpdate, "XML response not valid");
            }
            String tagName = xmlDoc.getTagName();
            if (!tagName.equals("ServerResponse")) {
                throw new WtcUpdateException(uriUpdate, "XML root node name is not \"ServerResponse\"");
            }
            String error = xmlDoc.getAttribute("Error");
            if (WtcString.isNullOrEmpty(error)) {
                throw new WtcUpdateException(uriUpdate, "ServerResponse node has no \"Error\" attribute");
            }
            int errorCode = Integer.parseInt(error);
            if (errorCode != 0) {
                throw new WtcUpdateErrorException(uriUpdate, clientPackageCode, errorCode);
            }
            NodeList sviNodes = xmlDoc.getElementsByTagName("SoftwareVersionInfo");
            if (sviNodes == null) {
                throw new WtcUpdateException(uriUpdate, "ServerResponse node has no \"SoftwareVersionInfo\" child node(s)");
            }
            int sviCount = sviNodes.getLength();
            if (sviCount != 1) {
                throw new WtcUpdateException(uriUpdate, "ServerResponse node \"SoftwareVersionInfo\" must only have one child node");
            }
            Node sviNode = sviNodes.item(0);
            WtcUpdate wtcUpdate = update = new WtcUpdate(sviNode, clientVersion);
            return wtcUpdate;
        }
        finally {
            WtcLog.info(TAG, "-checkForUpdate(proxy=" + proxy + ", clientPackageCode=\"" + clientPackageCode + "\", clientVersion=" + clientVersion + ")");
        }
    }

    public static class WtcUpdateErrorException
    extends WtcUpdateException {
        public final String clientPackageCode;
        public final int errorCode;

        public WtcUpdateErrorException(WtcUri uri, String clientPackageCode, int errorCode) {
            super(uri);
            this.clientPackageCode = clientPackageCode;
            this.errorCode = errorCode;
        }

        @Override
        public String toString() {
            return "WtcUpdateErrorException [clientPackageCode=\"" + this.clientPackageCode + "\", errorCode=" + WtcLocatorErrorCodes.toString(this.errorCode) + "]";
        }
    }

    public static class WtcUpdateException
    extends Exception {
        public final WtcUri uri;
        public final Exception innerException;

        protected WtcUpdateException(WtcUri uri) {
            this.uri = uri;
            this.innerException = null;
        }

        public WtcUpdateException(String message) {
            this(null, message, null);
        }

        public WtcUpdateException(WtcUri uri, String message) {
            this(uri, message, null);
        }

        public WtcUpdateException(WtcUri uri, String message, Exception innerException) {
            super(message);
            this.uri = uri;
            this.innerException = innerException;
        }
    }
}

