/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcConnectionStatistics;
import com.twistpair.wave.thinclient.logging.WtcLog;
import java.util.Timer;
import java.util.TimerTask;

public class WtcPingRequestRxTimeout {
    private static final String TAG = WtcLog.TAG(WtcPingRequestRxTimeout.class);
    private static final boolean VERBOSE_LOG = false;
    private final int INTERVAL_PING_MS_MAX = 120000;
    private final int INTERVAL_PING_MS_MIN = 5000;
    private final IPingRequestRxTimeoutListener listener;
    private final WtcConnectionStatistics connectionStatistics;
    private final Object syncCancel = new Object();
    private boolean closed;
    private Timer timer;
    private TimerTask timerTask;
    private short lastPingRequestTxId;
    private long timePingInterval;
    private long timeStarted;

    public WtcPingRequestRxTimeout(IPingRequestRxTimeoutListener listener, WtcConnectionStatistics connectionStatistics) {
        this.listener = listener;
        this.connectionStatistics = connectionStatistics;
        this.timer = new Timer();
        this.lastPingRequestTxId = 0;
        this.timePingInterval = 120000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            WtcLog.debug(TAG, "+close()");
            Object object = this.syncCancel;
            synchronized (object) {
                this.cancel();
                this.closed = true;
                if (this.timer != null) {
                    WtcLog.debug(TAG, "timer.cancel()");
                    this.timer.cancel();
                    this.timer = null;
                }
            }
        }
        finally {
            WtcLog.debug(TAG, "-close()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cancel() {
        Object object = this.syncCancel;
        synchronized (object) {
            long elapsedMs;
            if (this.closed) {
                return -1L;
            }
            if (this.timer != null && this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
                long now = System.currentTimeMillis();
                elapsedMs = now - this.timeStarted;
            } else {
                elapsedMs = 120000L;
            }
            return elapsedMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(boolean calculatePingInterval) {
        Object object = this.syncCancel;
        synchronized (object) {
            long elapsedMs = this.cancel();
            if (elapsedMs < 0L) {
                return;
            }
            if (calculatePingInterval) {
                long now = System.currentTimeMillis();
                this.timePingInterval = now - this.timeStarted;
            }
            long requestTimeoutMs = this.connectionStatistics.latency.getRequestTimeoutMs();
            int timeoutMs = (int)(Math.max(5000L, Math.min(this.timePingInterval, 120000L)) + requestTimeoutMs);
            this.schedule(timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule(final int timeoutMs) {
        Object object = this.syncCancel;
        synchronized (object) {
            long elapsedMs = this.cancel();
            if (elapsedMs < 0L) {
                return;
            }
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    WtcPingRequestRxTimeout.this.run(timeoutMs);
                }
            };
            this.timeStarted = System.currentTimeMillis();
            this.timer.schedule(this.timerTask, timeoutMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(int timeoutMs) {
        try {
            WtcLog.warn(TAG, "+run(timeoutMs=" + timeoutMs + ")");
            WtcPingRequestRxTimeout wtcPingRequestRxTimeout = this;
            synchronized (wtcPingRequestRxTimeout) {
                block10: {
                    if (this.timerTask != null) break block10;
                    return;
                }
                long elapsedMs = System.currentTimeMillis() - this.timeStarted;
                this.lastPingRequestTxId = this.listener.onPingRequestRxTimeout(timeoutMs, elapsedMs, this.lastPingRequestTxId);
                this.cancel();
            }
        }
        catch (Exception e) {
            WtcLog.error(TAG, "EXCEPTION run(timeoutMs=" + timeoutMs + ")", e);
        }
        finally {
            WtcLog.warn(TAG, "-run(timeoutMs=" + timeoutMs + ")");
        }
    }

    public static interface IPingRequestRxTimeoutListener {
        public short onPingRequestRxTimeout(long var1, long var3, short var5);
    }
}

