/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcLocator;
import com.twistpair.wave.thinclient.WtcLocatorErrorCodes;
import com.twistpair.wave.thinclient.WtcLocatorException;
import com.twistpair.wave.thinclient.WtcProxyInfo;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.util.WtcString;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WtcLocatorResponse {
    private static final String TAG = WtcLog.TAG(WtcLocator.class);
    public final int errorCode;
    public final WtcProxyInfo[] proxyInfos;

    public WtcLocatorResponse(Element element) throws WtcLocatorException.WtcLocatorResponseInvalidException {
        if (element == null) {
            throw new WtcLocatorException.WtcLocatorResponseInvalidException("XML is null/empty", element);
        }
        String tagName = element.getTagName();
        if (!tagName.equals("ServerResponse")) {
            throw new WtcLocatorException.WtcLocatorResponseInvalidException("XML root node name is not \"ServerResponse\"", element);
        }
        String error = element.getAttribute("Error");
        if (WtcString.isNullOrEmpty(error)) {
            throw new WtcLocatorException.WtcLocatorResponseInvalidException("ServerResponse node has no \"Error\" attribute", element);
        }
        this.errorCode = Integer.parseInt(error);
        NodeList proxyNodes = element.getElementsByTagName("Proxy");
        if (proxyNodes == null) {
            if (this.errorCode == 0) {
                throw new WtcLocatorException.WtcLocatorResponseInvalidException("ServerResponse node has no \"Proxy\" child node(s)", element);
            }
            this.proxyInfos = new WtcProxyInfo[0];
        } else {
            int proxyCount = proxyNodes.getLength();
            this.proxyInfos = new WtcProxyInfo[proxyCount];
            for (int i = 0; i < proxyCount; ++i) {
                Node proxyNode = proxyNodes.item(i);
                this.proxyInfos[i] = new WtcProxyInfo(proxyNode);
            }
        }
    }

    public boolean isOK() {
        return WtcLocatorErrorCodes.isOK(this.errorCode) && this.proxyInfos != null && this.proxyInfos.length > 0;
    }

    public boolean isError() {
        return !this.isOK();
    }

    public String toString() {
        return "WtcLocatorResponse [errorCode=" + WtcLocatorErrorCodes.toString(this.errorCode) + ", proxyInfos=" + WtcProxyInfo.toString(this.proxyInfos) + "]";
    }
}

