/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.util.WtcString;

public class WtcLocatorErrorCodes {
    public static final int OK = 0;
    public static final int ActionNotSupported = 1;
    public static final int NoProxyFound = 2;
    public static final int UnsupportedPackageCode = 3;

    public static boolean isOK(int errorCode) {
        return errorCode == 0;
    }

    public static boolean isError(int errorCode) {
        return errorCode != 0;
    }

    public static String getName(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "OK";
            }
            case 1: {
                return "Action Not Supported";
            }
            case 2: {
                return "No Proxy Found";
            }
            case 3: {
                return "Unsupported Package Code";
            }
        }
        return "?";
    }

    public static String toString(int errorCode) {
        return WtcLocatorErrorCodes.toString(errorCode, 'd');
    }

    public static String toString(int errorCode, char format) {
        switch (format) {
            case 'd': {
                return '\"' + WtcLocatorErrorCodes.getName(errorCode) + "\"(" + WtcString.formatNumber(errorCode, 1) + ')';
            }
        }
        return '\"' + WtcLocatorErrorCodes.getName(errorCode) + "\"(0x" + WtcString.toHexString(errorCode, 1) + ')';
    }
}

