/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClientPhoneCallManager;
import com.twistpair.wave.thinclient.WtcClientPhoneLine;
import com.twistpair.wave.thinclient.WtcStack;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallDtmf;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpCallOffer;
import com.twistpair.wave.thinclient.util.WtcString;

public class WtcClientPhoneCall {
    private static final String TAG = WtcLog.TAG(WtcClientPhoneCall.class);
    public static final String CALL_TYPE_ENDPOINT_PREFIX = "EP#";
    private final WtcClientPhoneCallManager mCallManager;
    private final byte mCallType;
    private final WtcClientPhoneLine mPhoneLine;
    private final String mRemoteName;
    private final int mCallId;
    private final String mRemoteNumber;
    private final boolean mIsOutgoingCall;
    private final Object mSyncState = new Object();
    private int mCallProgressState = 0;
    private int mCallTalkState = 0;

    protected WtcClientPhoneCall(WtcClientPhoneCallManager callManager, WtcClientPhoneCallManager.CallMakeWrapper callMakeInfo, WtcpCallInfo callInfo) {
        if (callManager == null) {
            throw new IllegalArgumentException("callManager cannot be null");
        }
        if (callMakeInfo == null) {
            throw new IllegalArgumentException("callMakeInfo cannot be null");
        }
        if (callMakeInfo.mPhoneLine == null) {
            throw new IllegalArgumentException("callMakeInfo.mPhoneLine cannot be null");
        }
        if (callInfo == null) {
            throw new IllegalArgumentException("callInfo cannot be null");
        }
        this.mCallManager = callManager;
        this.mPhoneLine = callMakeInfo.mPhoneLine;
        this.mPhoneLine.setPhoneCall(this);
        this.mCallType = callMakeInfo.mCallType;
        this.mRemoteName = callMakeInfo.mRemoteName;
        this.mCallId = callInfo.callId;
        this.mRemoteNumber = callInfo.remoteNumber;
        this.mIsOutgoingCall = true;
    }

    protected WtcClientPhoneCall(WtcClientPhoneCallManager callManager, WtcClientPhoneLine phoneLine, WtcpCallOffer callOffer) {
        if (callManager == null) {
            throw new IllegalArgumentException("callManager cannot be null");
        }
        if (phoneLine == null) {
            throw new IllegalArgumentException("phoneLine cannot be null");
        }
        if (callOffer == null) {
            throw new IllegalArgumentException("callOffer cannot be null");
        }
        this.mCallManager = callManager;
        this.mPhoneLine = phoneLine;
        this.mPhoneLine.setPhoneCall(this);
        String remoteName = callOffer.fromName;
        if (remoteName.startsWith(CALL_TYPE_ENDPOINT_PREFIX)) {
            this.mCallType = 1;
            this.mRemoteName = remoteName.substring(CALL_TYPE_ENDPOINT_PREFIX.length());
        } else {
            this.mCallType = (byte)2;
            this.mRemoteName = remoteName;
        }
        this.mCallId = callOffer.callId;
        this.mRemoteNumber = callOffer.fromNumber;
        this.mIsOutgoingCall = false;
    }

    public String toString() {
        return new StringBuffer().append('{').append("mPhoneLine=").append(this.mPhoneLine).append(", mCallId=").append(this.mCallId).append(", mCallType=").append(WtcpConstants.WtcpCallType.toString(this.mCallType)).append(", mRemoteName=").append(WtcString.quote(this.mRemoteName)).append(", mRemoteNumber=").append(WtcString.quote(this.mRemoteNumber)).append(", mIsOutgoingCall=").append(this.mIsOutgoingCall).append(", mCallProgressState=").append(WtcpConstants.WtcpCallProgressState.toString(this.mCallProgressState)).append(", mCallTalkState=").append(CallTalkState.toString(this.mCallTalkState)).append('}').toString();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof WtcClientPhoneCall) {
            return this.getCallId() == ((WtcClientPhoneCall)o).getCallId();
        }
        return false;
    }

    protected WtcStack getStack() {
        return this.mPhoneLine.getStack();
    }

    public int getCallId() {
        return this.mCallId;
    }

    public byte getCallType() {
        return this.mCallType;
    }

    public WtcClientPhoneLine getPhoneLine() {
        return this.mPhoneLine;
    }

    public String getRemoteName() {
        return this.mRemoteName;
    }

    public String getRemoteNumber() {
        return this.mRemoteNumber;
    }

    public boolean getIsOutgoingCall() {
        return this.mIsOutgoingCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsCallConnected() {
        Object object = this.mSyncState;
        synchronized (object) {
            return this.mCallProgressState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCallProgressState() {
        Object object = this.mSyncState;
        synchronized (object) {
            return this.mCallProgressState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCallProgressState(int progressState) {
        Object object = this.mSyncState;
        synchronized (object) {
            WtcLog.info(TAG, "setCallProgressState(" + WtcpConstants.WtcpCallProgressState.toString(progressState) + ")");
            this.mCallProgressState = progressState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCallTalkState() {
        Object object = this.mSyncState;
        synchronized (object) {
            return this.mCallTalkState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCallTalkState(int talkState) {
        Object object = this.mSyncState;
        synchronized (object) {
            WtcLog.info(TAG, "setCallTalkState(" + CallTalkState.toString(talkState) + ")");
            this.mCallTalkState = talkState;
        }
    }

    public Integer answer() {
        return this.mCallManager.answer(this);
    }

    public Integer hangup() {
        return this.mCallManager.hangup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallHangup() {
        WtcLog.info(TAG, "+onCallHangup()");
        Object object = this.mSyncState;
        synchronized (object) {
            this.setCallProgressState(0);
            this.mPhoneLine.setPhoneCall(null);
        }
        WtcLog.info(TAG, "-onCallHangup()");
    }

    public Integer dtmf(String digits) {
        return this.mCallManager.dtmf(this, digits);
    }

    protected void onCallDtmf(WtcpControlHeader controlHeader, WtcpCallDtmf callDtmf) {
        WtcLog.info(TAG, "+onCallDtmf(..., callDtmf=" + callDtmf + ")");
        WtcLog.info(TAG, "-onCallDtmf(..., callDtmf=" + callDtmf + ")");
    }

    public Integer pushToTalk(boolean on) {
        return this.mCallManager.pushToTalk(this, on);
    }

    public static abstract class CallTalkState {
        public static final int OFF = 0;
        public static final int ONING = 1;
        public static final int ON = 2;
        public static final int OFFING = 3;

        public static String getName(int talkState) {
            switch (talkState) {
                case 0: {
                    return "OFF";
                }
                case 1: {
                    return "ONING";
                }
                case 2: {
                    return "ON";
                }
                case 3: {
                    return "OFFING";
                }
            }
            return "?";
        }

        public static String toString(int talkState) {
            return CallTalkState.toString(talkState, 'd');
        }

        public static String toString(int talkState, char format) {
            switch (format) {
                case 'd': {
                    return '\"' + CallTalkState.getName(talkState) + "\"(" + WtcString.formatNumber(talkState, 1) + ')';
                }
            }
            return '\"' + CallTalkState.getName(talkState) + "\"(0x" + WtcString.toHexString(talkState, 2) + ')';
        }
    }
}

