/*
 * Decompiled with CFR 0.152.
 */
package com.twistpair.wave.thinclient;

import com.twistpair.wave.thinclient.WtcClient;
import com.twistpair.wave.thinclient.WtcClientChannel;
import com.twistpair.wave.thinclient.WtcClientListener;
import com.twistpair.wave.thinclient.logging.WtcLog;
import com.twistpair.wave.thinclient.protocol.WtcpConstants;
import com.twistpair.wave.thinclient.protocol.headers.WtcpControlHeader;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelActivity;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdErrorDictionary;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelIdList;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfo;
import com.twistpair.wave.thinclient.protocol.types.WtcpChannelInfoList;
import com.twistpair.wave.thinclient.protocol.types.WtcpErrorCode;
import com.twistpair.wave.thinclient.protocol.types.WtcpKeyValueList;
import com.twistpair.wave.thinclient.protocol.types.WtcpStringList;
import com.twistpair.wave.thinclient.util.WtcInt32;
import com.twistpair.wave.thinclient.util.WtcIntegerObjectMapPlatform;
import com.twistpair.wave.thinclient.util.WtcString;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class WtcClientChannelManager {
    private static final String TAG = WtcLog.TAG(WtcClientChannelManager.class);
    public boolean AUTO_MUTE_CHANNELS = false;
    private static final boolean VERBOSE_LOG = false;
    private final Hashtable mChannelsAll = new Hashtable();
    private final WtcpChannelIdList mChannelsPttOningOrOn = new WtcpChannelIdList();
    private final WtcClient mClient;
    private boolean mReceivedChannels;
    public static final String[] CHANNEL_PROPERTIES_ALL = new String[]{"*"};

    public WtcClientChannelManager(WtcClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        this.mClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            this.mChannelsAll.clear();
        }
    }

    public boolean hasReceivedChannels() {
        return this.mReceivedChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChannels(WtcpChannelInfoList channels) {
        WtcLog.info(TAG, "setChannels(...): Setting channels " + channels);
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            this.mReceivedChannels = true;
            this.mChannelsAll.clear();
            Enumeration channelInfos = channels.elements();
            while (channelInfos.hasMoreElements()) {
                WtcpChannelInfo channelInfo = (WtcpChannelInfo)channelInfos.nextElement();
                WtcClientChannel channel = new WtcClientChannel(this, channelInfo);
                this.mChannelsAll.put(WtcInt32.valueOf(channelInfo.id, true), channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getChannels() {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            return this.mChannelsAll.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTalkingOnAnyChannel() {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            return this.mChannelsPttOningOrOn.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcpChannelIdList getChannelIds() {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            WtcpChannelIdList channelIds = new WtcpChannelIdList();
            Enumeration channels = this.mChannelsAll.elements();
            while (channels.hasMoreElements()) {
                channelIds.addElement(((WtcClientChannel)channels.nextElement()).getIdSession());
            }
            return channelIds;
        }
    }

    public WtcClientChannel getChannel(int id) {
        return this.getChannel(WtcInt32.valueOf(id, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WtcClientChannel getChannel(WtcInt32 id) {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            return (WtcClientChannel)this.mChannelsAll.get(id);
        }
    }

    public WtcClientChannel getChannel(String name) throws NoSuchElementException {
        Hashtable hashtable = this.mChannelsAll;
        synchronized (hashtable) {
            Enumeration channels = this.mChannelsAll.elements();
            while (channels.hasMoreElements()) {
                WtcClientChannel channel = (WtcClientChannel)channels.nextElement();
                if (!channel.getName().equalsIgnoreCase(name)) continue;
                return channel;
            }
            throw new NoSuchElementException();
        }
    }

    private WtcpChannelIdList createChannelIdList(WtcInt32 id) {
        WtcpChannelIdList list = new WtcpChannelIdList();
        list.addElement(id);
        return list;
    }

    public Integer activate(int channelId, boolean on) {
        return this.activate(WtcInt32.valueOf(channelId, true), on ? 1 : 0);
    }

    public Integer activate(int channelId, int opType) {
        return this.activate(WtcInt32.valueOf(channelId, true), opType);
    }

    public Integer activate(WtcInt32 channelId, boolean on) {
        return this.activate(channelId, on ? 1 : 0);
    }

    public Integer activate(WtcInt32 channelId, int opType) {
        return this.activate(this.createChannelIdList(channelId), opType);
    }

    public Integer activate(WtcpChannelIdList channelIds, boolean on) {
        return this.activate(channelIds, on ? 1 : 0);
    }

    public Integer activate(WtcpChannelIdList channelIds, int opType) {
        return this.doChannelOperationRequest(channelIds, 10, opType);
    }

    public Integer talk(int channelId, boolean on) {
        return this.talk(WtcInt32.valueOf(channelId, true), on ? 1 : 0);
    }

    public Integer talk(int channelId, int opType) {
        return this.talk(WtcInt32.valueOf(channelId, true), opType);
    }

    public Integer talk(WtcInt32 channelId, boolean on) {
        return this.talk(channelId, on ? 1 : 0);
    }

    public Integer talk(WtcInt32 channelId, int opType) {
        return this.talk(this.createChannelIdList(channelId), opType);
    }

    public Integer talk(WtcpChannelIdList channelIds, boolean on) {
        return this.talk(channelIds, on ? 1 : 0);
    }

    public Integer talk(WtcpChannelIdList channelIds, int opType) {
        return this.doChannelOperationRequest(channelIds, 13, opType);
    }

    public Integer mute(int channelId, boolean on) {
        return this.mute(WtcInt32.valueOf(channelId, true), on ? 1 : 0);
    }

    public Integer mute(int channelId, int opType) {
        return this.mute(WtcInt32.valueOf(channelId, true), opType);
    }

    public Integer mute(WtcInt32 channelId, boolean on) {
        return this.mute(channelId, on ? 1 : 0);
    }

    public Integer mute(WtcInt32 channelId, int opType) {
        return this.mute(this.createChannelIdList(channelId), opType);
    }

    public Integer mute(WtcpChannelIdList channelIds, boolean on) {
        return this.mute(channelIds, on ? 1 : 0);
    }

    public Integer mute(WtcpChannelIdList channelIds, int opType) {
        return this.doChannelOperationRequest(channelIds, 14, opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Integer doChannelOperationRequest(WtcpChannelIdList channelIds, int opCode, int opType) {
        try {
            WtcLog.debug(TAG, "+doChannelOperationRequest(" + channelIds + ", " + WtcpConstants.WtcpOpCode.toString(opCode) + ", " + ChannelOperationType.toString(opType) + ")");
            Hashtable hashtable = this.mChannelsAll;
            synchronized (hashtable) {
                if (channelIds == null) {
                    channelIds = new WtcpChannelIdList();
                }
                switch (opCode) {
                    case 13: {
                        this.mChannelsPttOningOrOn.removeAllElements();
                        break;
                    }
                }
                WtcpChannelIdList channelsRequest = new WtcpChannelIdList();
                Enumeration it = this.mChannelsAll.elements();
                block34: while (it.hasMoreElements()) {
                    WtcClientChannel channel = (WtcClientChannel)it.nextElement();
                    WtcInt32 channelId = channel.getIdSession();
                    switch (opCode) {
                        case 10: {
                            switch (opType) {
                                case 2: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mActive.setOning();
                                        channelsRequest.addElement(channelId);
                                        break;
                                    }
                                    channel.mActive.setOffing();
                                    break;
                                }
                                case 1: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mActive.setOning();
                                        channelsRequest.addElement(channelId);
                                        break;
                                    }
                                    if (!channel.mActive.isOningOrOn() || channel.mActive.isOffing()) continue block34;
                                    channelsRequest.addElement(channelId);
                                    break;
                                }
                                case 0: {
                                    if (channelIds.size() == 0 || channelIds.contains(channelId)) {
                                        channel.mActive.setOffing();
                                        break;
                                    }
                                    if (!channel.mActive.isOningOrOn() || channel.mActive.isOffing()) continue block34;
                                    channelsRequest.addElement(channelId);
                                    continue block34;
                                }
                            }
                            break;
                        }
                        case 13: {
                            switch (opType) {
                                case 2: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mPtt.setOning();
                                        channelsRequest.addElement(channelId);
                                        break;
                                    }
                                    channel.mPtt.setOffing();
                                    break;
                                }
                                case 1: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mPtt.setOning();
                                        channelsRequest.addElement(channelId);
                                        this.mChannelsPttOningOrOn.addElement(channelId);
                                        break;
                                    }
                                    if (!channel.mPtt.isOningOrOn() || channel.mPtt.isOffing()) continue block34;
                                    channelsRequest.addElement(channelId);
                                    this.mChannelsPttOningOrOn.addElement(channelId);
                                    break;
                                }
                                case 0: {
                                    if (channelIds.size() == 0 || channelIds.contains(channelId)) {
                                        channel.mPtt.setOffing();
                                        break;
                                    }
                                    if (!channel.mPtt.isOningOrOn() || channel.mPtt.isOffing()) continue block34;
                                    channelsRequest.addElement(channelId);
                                    this.mChannelsPttOningOrOn.addElement(channelId);
                                    continue block34;
                                }
                            }
                            break;
                        }
                        case 14: {
                            switch (opType) {
                                case 2: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mMute.setOning();
                                        channelsRequest.addElement(channelId);
                                        break;
                                    }
                                    channel.mMute.setOffing();
                                    break;
                                }
                                case 1: {
                                    if (channelIds.contains(channelId)) {
                                        channel.mMute.setOning();
                                        channelsRequest.addElement(channelId);
                                        break;
                                    }
                                    if (!channel.mMute.isOningOrOn() || channel.mMute.isOffing()) break;
                                    channelsRequest.addElement(channelId);
                                    break;
                                }
                                case 0: {
                                    if (channelIds.size() == 0 || channelIds.contains(channelId)) {
                                        channel.mMute.setOffing();
                                        break;
                                    }
                                    if (!channel.mMute.isOningOrOn() || channel.mMute.isOffing()) break;
                                    channelsRequest.addElement(channelId);
                                }
                            }
                            continue block34;
                        }
                    }
                }
                Integer transactionId = null;
                switch (opCode) {
                    case 10: {
                        transactionId = this.mClient.channelsSetActive(channelsRequest);
                        break;
                    }
                    case 13: {
                        transactionId = this.mClient.channelsPushToTalk(channelsRequest);
                        break;
                    }
                    case 14: {
                        transactionId = this.mClient.channelsMute(channelsRequest);
                        break;
                    }
                }
                Integer n = transactionId;
                return n;
            }
        }
        finally {
            WtcLog.debug(TAG, "-doChannelOperationRequest(" + channelIds + ", " + WtcpConstants.WtcpOpCode.toString(opCode) + ", " + ChannelOperationType.toString(opType) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WtcIntegerObjectMapPlatform onChannelOperation(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, WtcpChannelIdErrorDictionary channelIdErrors) {
        try {
            int opCode;
            WtcLog.debug(TAG, "+onChannelOperation: controlHeader=" + controlHeader + ", channelIdErrors=" + channelIdErrors);
            WtcIntegerObjectMapPlatform allAutoOpChannelIds = new WtcIntegerObjectMapPlatform();
            Hashtable hashtable = this.mChannelsAll;
            synchronized (hashtable) {
                int transactionId = controlHeader.transactionId;
                opCode = controlHeader.getOpCode();
                int opType = controlHeader.getOpType();
                boolean isUnsolicited = controlHeader.isUnsolicited();
                if (isUnsolicited) {
                    WtcLog.info(TAG, "RX UNSOLICITED " + WtcpConstants.WtcpOpCode.toString(opCode));
                }
                boolean autoMuteChannels = this.AUTO_MUTE_CHANNELS;
                Enumeration it = this.mChannelsAll.elements();
                while (it.hasMoreElements()) {
                    boolean hasErrorCode;
                    WtcClientChannel channel = (WtcClientChannel)it.nextElement();
                    WtcInt32 channelId = channel.getIdSession();
                    WtcpErrorCode errorCode = (WtcpErrorCode)channelIdErrors.get(channelId);
                    boolean bl = hasErrorCode = errorCode != null;
                    if (hasErrorCode) {
                        if (errorCode.isOK()) {
                            switch (opCode) {
                                case 10: {
                                    boolean alreadyOn;
                                    if (autoMuteChannels) {
                                        WtcpChannelIdList autoOpChannelIds = (WtcpChannelIdList)allAutoOpChannelIds.get(14);
                                        if (autoOpChannelIds == null) {
                                            autoOpChannelIds = new WtcpChannelIdList();
                                        }
                                        autoOpChannelIds.addElement(channelId);
                                        allAutoOpChannelIds.put(14, (Object)autoOpChannelIds);
                                    }
                                    if ((alreadyOn = channel.mActive.setOn(true)) || listener == null) break;
                                    listener.onChannelActivated(client, opType, transactionId, channel);
                                    break;
                                }
                                case 13: {
                                    boolean alreadyOn;
                                    boolean isLatestChannelOperationOningOrOn = this.mChannelsPttOningOrOn.contains(channelId);
                                    if (isLatestChannelOperationOningOrOn) {
                                        alreadyOn = channel.mPtt.setOn(true);
                                        if (alreadyOn || listener == null) break;
                                        listener.onChannelTalkStarted(client, opType, transactionId, channel);
                                        break;
                                    }
                                    if (!channel.mPtt.isOffing()) break;
                                    channel.mPtt.setOn(false);
                                    if (listener == null) break;
                                    listener.onChannelTalkStopped(client, opType, transactionId, channel, errorCode);
                                    break;
                                }
                                case 14: {
                                    boolean alreadyOn = channel.mMute.setOn(true);
                                    if (alreadyOn || listener == null) break;
                                    listener.onChannelMuteOn(client, opType, transactionId, channel);
                                }
                            }
                            continue;
                        }
                        switch (controlHeader.getOpCode()) {
                            case 10: {
                                this.mChannelsPttOningOrOn.removeElement(channelId);
                                channel.mActive.setOn(false);
                                if (listener == null) break;
                                listener.onChannelDeactivated(client, opType, transactionId, channel, errorCode);
                                break;
                            }
                            case 13: {
                                this.mChannelsPttOningOrOn.removeElement(channelId);
                                channel.mPtt.setOn(false);
                                if (listener == null) break;
                                listener.onChannelTalkStopped(client, opType, transactionId, channel, errorCode);
                                break;
                            }
                            case 14: {
                                channel.mMute.setOn(false);
                                if (listener == null) break;
                                listener.onChannelMuteOff(client, opType, transactionId, channel, errorCode);
                            }
                        }
                        continue;
                    }
                    switch (opCode) {
                        case 10: {
                            if (!channel.mActive.isOningOrOn() || !channel.mActive.isOffing() && !isUnsolicited) break;
                            channel.mActive.setOn(false);
                            this.mChannelsPttOningOrOn.removeElement(channelId);
                            if (listener == null) break;
                            listener.onChannelDeactivated(client, opType, transactionId, channel, WtcpErrorCode.OK);
                            break;
                        }
                        case 13: {
                            if (!channel.mPtt.isOningOrOn() || !channel.mPtt.isOffing() && !isUnsolicited) break;
                            channel.mPtt.setOn(false);
                            this.mChannelsPttOningOrOn.removeElement(channelId);
                            if (listener == null) break;
                            listener.onChannelTalkStopped(client, opType, transactionId, channel, WtcpErrorCode.OK);
                            break;
                        }
                        case 14: {
                            if (!channel.mMute.isOningOrOn() || !channel.mMute.isOffing() && !isUnsolicited) break;
                            channel.mMute.setOn(false);
                            if (listener == null) break;
                            listener.onChannelMuteOff(client, opType, transactionId, channel, WtcpErrorCode.OK);
                        }
                    }
                }
            }
            WtcIntegerObjectMapPlatform allAutoOpTransactionIds = null;
            if (allAutoOpChannelIds.size() > 0) {
                allAutoOpTransactionIds = new WtcIntegerObjectMapPlatform();
                Enumeration keys = allAutoOpChannelIds.keys();
                while (keys.hasMoreElements()) {
                    opCode = (Integer)keys.nextElement();
                    WtcpChannelIdList channelIds = (WtcpChannelIdList)allAutoOpChannelIds.get(opCode);
                    switch (opCode) {
                        case 14: {
                            Integer transactionId = this.doChannelOperationRequest(channelIds, opCode, 1);
                            allAutoOpTransactionIds.put(opCode, (Object)transactionId);
                        }
                    }
                }
            }
            WtcIntegerObjectMapPlatform wtcIntegerObjectMapPlatform = allAutoOpTransactionIds;
            return wtcIntegerObjectMapPlatform;
        }
        finally {
            WtcLog.debug(TAG, "-onChannelOperation: controlHeader=" + controlHeader + ", channelIdErrors=" + channelIdErrors);
        }
    }

    public Integer getChannelProperty(WtcInt32 channelId, String key) {
        String[] stringArray;
        if (WtcString.isNullOrEmpty(key)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = key;
        }
        return this.getChannelProperties(channelId, stringArray);
    }

    public Integer getChannelProperties(WtcInt32 channelId, String[] keys) {
        if (keys == null) {
            keys = CHANNEL_PROPERTIES_ALL;
        }
        return this.getChannelProperties(channelId, new WtcpStringList(keys));
    }

    public Integer getChannelProperties(WtcInt32 channelId, WtcpStringList keys) {
        return this.mClient.channelPropertiesGet(channelId, keys);
    }

    public Integer setChannelProperty(WtcInt32 channelId, String key, String value) {
        if (WtcString.isNullOrEmpty(key)) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
        if (WtcString.isNullOrEmpty(value)) {
            value = "";
        }
        WtcpKeyValueList properties = new WtcpKeyValueList();
        properties.put(key, value);
        return this.setChannelProperties(channelId, properties);
    }

    public Integer setChannelProperties(WtcInt32 channelId, WtcpKeyValueList properties) {
        return this.mClient.channelPropertiesSet(channelId, properties);
    }

    public void onChannelPropertiesGet(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, int channelId, WtcpKeyValueList keyValues) {
        WtcLog.debug(TAG, "onChannelPropertiesGet: controlHeader=" + controlHeader + ", channelId=" + channelId + ", keyValues=" + keyValues);
        WtcClientChannel channel = this.getChannel(channelId);
        channel.updateProperties(keyValues);
        if (listener != null) {
            listener.onChannelPropertiesGet(client, controlHeader.getOpType(), controlHeader.transactionId, channel, keyValues);
        }
    }

    public void onChannelPropertiesGet(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, int channelId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onChannelPropertiesGetError: channelId=" + channelId + ", errorCode=" + errorCode);
        WtcClientChannel channel = this.getChannel(channelId);
        if (listener != null) {
            listener.onChannelPropertiesGetError(client, controlHeader.getOpType(), controlHeader.transactionId, channel, errorCode);
        }
    }

    public void onChannelPropertiesSet(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, int channelId, WtcpErrorCode errorCode) {
        WtcLog.debug(TAG, "onChannelPropertiesSet: channelId=" + channelId + ", errorCode=" + errorCode);
        WtcClientChannel channel = this.getChannel(channelId);
        if (listener != null) {
            listener.onChannelPropertiesSet(client, controlHeader.getOpType(), controlHeader.transactionId, channel, errorCode);
        }
    }

    public void onChannelActivity(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, WtcpChannelActivity channelActivity) {
        int channelId = channelActivity.channelId;
        WtcClientChannel channel = this.getChannel(channelId);
        channel.updateActivity(channelActivity.channelFlags, channelActivity.endpointCount, channelActivity.activityEndpoints);
        if (listener != null && !listener.onChannelActivity(client, controlHeader.getOpType(), controlHeader.transactionId, channel, channelActivity)) {
            listener.onChannelActivity(client, controlHeader.getOpType(), controlHeader.transactionId, channel, channelActivity.channelFlags, channelActivity.activityEndpoints);
        }
    }

    public void onChannelActivity(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, WtcpErrorCode errorCode) {
        WtcLog.warn(TAG, "onChannelActivity: controlHeader=" + controlHeader + ", errorCode=" + errorCode);
        if (listener != null) {
            listener.onChannelActivityError(client, controlHeader.getOpType(), controlHeader.transactionId, errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelChange(WtcClient client, WtcClientListener listener, WtcpControlHeader controlHeader, boolean reconnect, int change, int channelId) {
        WtcInt32 channelKey = WtcInt32.valueOf(channelId, true);
        switch (change) {
            case 1: {
                String name = "channelId" + channelId;
                WtcpChannelInfo channelInfo = new WtcpChannelInfo(channelId, 0, name);
                WtcClientChannel channel = new WtcClientChannel(this, channelInfo);
                if (this.AUTO_MUTE_CHANNELS) {
                    channel.mute(true);
                }
                Hashtable hashtable = this.mChannelsAll;
                synchronized (hashtable) {
                    this.mChannelsAll.put(channelKey, channel);
                    break;
                }
            }
            case 2: {
                Hashtable hashtable = this.mChannelsAll;
                synchronized (hashtable) {
                    this.mChannelsAll.remove(channelKey);
                    this.mChannelsPttOningOrOn.removeElement(channelKey);
                    break;
                }
            }
        }
        if (listener != null) {
            listener.onChannelChange(client, controlHeader.getOpType(), controlHeader.transactionId, reconnect, change, channelId);
        }
    }

    public static class ChannelOperationType {
        public static final int OFF = 0;
        public static final int ON = 1;
        public static final int ABSOLUTE = 2;

        public static String toString(int opType) {
            switch (opType) {
                case 0: {
                    return "OFF";
                }
                case 1: {
                    return "ON";
                }
                case 2: {
                    return "ABSOLUTE";
                }
            }
            return "{UNKNOWN}";
        }
    }
}

