package com.twistpair.wave.thinclient.util;

public class WtcInt32 extends WtcScalar
{
    /**
     * Improves memory performance by caching CHANNEL IDS (and other commonly used WtcInt32s)!<br>
     * It doesn't make much sense to cache flags, etc, since those can and will change very often.<br>
     * If we cached those then we would have hundreds to thousands of useless values in memory.<br>
     * Channel ID's won't grow much over time and will repeat very often; it makes sense to cache those.<br>
     * TODO:(pv) In the future we could perhaps even put a timer on the objects and remove the ones that haven't been used in awhile.
     * @param value
     * @param cache
     * @return WtcInt32
     */
    public static WtcInt32 valueOf(int value, boolean cache)
    {
        if (cache)
        {
            return WtcInt32CachePlatform.valueOf(value);
        }
        else
        {
            return new WtcInt32(value);
        }
    }

    // TODO:(pv) Call this when signing out (or exiting?)
    public static void clear()
    {
        WtcInt32CachePlatform.clear();
    }

    public static final WtcInt32 ZERO = WtcInt32.valueOf(0, true);

    public final int             value;

    protected WtcInt32(int value)
    {
        super(true);
        this.value = value;
    }

    protected WtcInt32(IWtcMemoryStream inputStream)
    {
        this(inputStream.readInt32());
    }

    public String toString()
    {
        return String.valueOf(value);
    }

    public boolean equals(Object o)
    {
        if (o == null || !(o instanceof WtcInt32))
        {
            return false;
        }

        return this.value == ((WtcInt32) o).value;
    }

    public int hashCode()
    {
        int result = 17;
        result = 31 * result + value;
        return result;
    }
}
