package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Vector;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpStringList
//
public class WtcpStringList //
                extends WtcpList //
                implements IWtcpSendable, IWtcpReceivable
{
    public WtcpStringList()
    {
        super(String.class);
    }

    public WtcpStringList(String[] items)
    {
        super(String.class, items);
    }

    public WtcpStringList(Vector items)
    {
        super(String.class, items);
    }

    public WtcpStringList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        String value;
        for (int i = 0; i < count; i++)
        {
            value = inputStream.readString();
            this.addElement(value);
        }
    }

    public void dumpHostToNetworkOrder(IWtcMemoryStream outputStream)
    {
        outputStream.writeInt16((short) this.size());
        String value;
        Enumeration elements = this.elements();
        while (elements.hasMoreElements())
        {
            value = (String) elements.nextElement();
            outputStream.writeString(value);
        }
    }

    public String toString()
    {
        Enumeration elements = this.elements();
        String element;

        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements())
        {
            element = (String) elements.nextElement();
            sb.append('\"').append(element).append('\"');
            if (elements.hasMoreElements())
            {
                sb.append(',');
            }

        }
        sb.append(']');
        return sb.toString();
    }
}
//
// END WtcpStringList
//
