package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.IWtcSortable;
import com.twistpair.wave.thinclient.util.WtcArraysPlatform;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;

//
// BEGIN WtcpProfileInfoList
//
public class WtcpProfileInfoList //
                extends WtcpList //
                implements IWtcpReceivable, IWtcSortable
{
    public WtcpProfileInfoList()
    {
        super(WtcpProfileInfo.class);
    }

    public WtcpProfileInfoList(WtcpProfileInfoList other)
    {
        super(WtcpProfileInfo.class, other);
    }

    public WtcpProfileInfoList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        WtcpProfileInfo profileInfo;
        for (int i = 0; i < count; i++)
        {
            profileInfo = new WtcpProfileInfo(inputStream);
            this.addElement(profileInfo);
        }
    }

    public String toString()
    {
        Enumeration elements = this.elements();
        WtcpProfileInfo element;

        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements())
        {
            element = (WtcpProfileInfo) elements.nextElement();
            sb.append(element);
            if (elements.hasMoreElements())
            {
                sb.append(',');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public WtcComparatorPlatform getComparator()
    {
        return WtcpProfileInfo.COMPARATOR;
    }

    public void sort()
    {
        WtcArraysPlatform.sort(vector, getComparator());
    }
}
//
// END WtcpProfileInfoList
//
