package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.protocol.WtcpConstants.WtcpErrorCodes;
import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpErrorCode
//
public class WtcpErrorCode //
                implements IWtcpReceivable
{
    public static final WtcpErrorCode OK = new WtcpErrorCode(WtcpErrorCodes.OK);

    public static boolean isOk(WtcpErrorCode errorCode)
    {
        return (errorCode == null || errorCode.isOK());
    }

    public static boolean isError(WtcpErrorCode errorCode)
    {
        return (errorCode != null && errorCode.isError());
    }

    private int errorCode;
    private int subErrorCode;

    public int getErrorCode()
    {
        return errorCode;
    }

    public int getSubErrorCode()
    {
        return subErrorCode;
    }

    public boolean isOK()
    {
        return errorCode == WtcpErrorCodes.OK;
    }

    public boolean isError()
    {
        return errorCode != WtcpErrorCodes.OK;
    }

    public WtcpErrorCode(int errorCode)
    {
        this.errorCode = errorCode;
        this.subErrorCode = 0;
    }

    public WtcpErrorCode(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        errorCode = inputStream.readInt8();
        if (errorCode == WtcpErrorCodes.WtcpTransmissionError)
        {
            subErrorCode = inputStream.readInt8();
        }
        else
        {
            subErrorCode = WtcpErrorCodes.OK;
        }
    }

    public boolean equals(Object o)
    {
        if (o == null)
        {
            return false;
        }

        if (!(o instanceof WtcpErrorCode))
        {
            return false;
        }

        return (this.errorCode == ((WtcpErrorCode) o).errorCode) //
                        && (this.subErrorCode == ((WtcpErrorCode) o).subErrorCode);
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append("{errorCode=").append(WtcpErrorCodes.toString(errorCode));
        if (errorCode == WtcpErrorCodes.WtcpTransmissionError)
        {
            sb.append(", subErrorCode=").append(WtcpErrorCodes.toString(subErrorCode));
        }
        sb.append('}');
        return sb.toString();
    }
}
//
// END WtcpErrorCode
//
