package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.IWtcSortable;
import com.twistpair.wave.thinclient.util.WtcArraysPlatform;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;

//
// BEGIN WtcpEndpointInfoList
//
public class WtcpEndpointInfoList //
                extends WtcpList //
                implements IWtcpReceivable, IWtcSortable
{
    public WtcpEndpointInfoList()
    {
        super(WtcpEndpointInfo.class);
    }

    public WtcpEndpointInfoList(Enumeration enumeration)
    {
        this();
        addElements(enumeration);
    }

    public WtcpEndpointInfoList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        WtcpEndpointInfo endpointInfo;
        for (int i = 0; i < count; i++)
        {
            endpointInfo = new WtcpEndpointInfo(inputStream);
            addElement(endpointInfo);
        }
    }

    public WtcComparatorPlatform getComparator()
    {
        return WtcpEndpointInfo.COMPARATOR;
    }

    public void sort()
    {
        WtcArraysPlatform.sort(vector, getComparator());
    }
}
//
// END WtcpEndpointInfoList
//
