package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.IWtcSortable;
import com.twistpair.wave.thinclient.util.WtcArraysPlatform;
import com.twistpair.wave.thinclient.util.WtcComparatorPlatform;

//
// BEGIN WtcpChannelInfoList
//
public class WtcpChannelInfoList //
                extends WtcpList //
                implements IWtcpReceivable, IWtcSortable
{
    public WtcpChannelInfoList()
    {
        super(WtcpChannelInfo.class);
    }

    public WtcpChannelInfoList(WtcpChannelInfoList other)
    {
        super(WtcpChannelInfo.class, other);
    }

    public WtcpChannelInfoList(IWtcMemoryStream inputStream)
    {
        this();
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        WtcpChannelInfo channelInfo;
        for (int i = 0; i < count; i++)
        {
            channelInfo = new WtcpChannelInfo(inputStream);
            this.addElement(channelInfo);
        }
    }

    public String toString()
    {
        Enumeration elements = this.elements();
        WtcpChannelInfo element;

        StringBuffer sb = new StringBuffer();
        sb.append('[');
        while (elements.hasMoreElements())
        {
            element = (WtcpChannelInfo) elements.nextElement();
            sb.append('\"').append(element).append('\"');
            if (elements.hasMoreElements())
            {
                sb.append(',');
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public WtcComparatorPlatform getComparator()
    {
        return WtcpChannelInfo.COMPARATOR;
    }

    public void sort()
    {
        WtcArraysPlatform.sort(vector, getComparator());
    }
}
//
// END WtcpChannelInfoList
//
