package com.twistpair.wave.thinclient.protocol.types;

import java.util.Enumeration;
import java.util.Hashtable;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcInt32;

//
// BEGIN WtcpChannelIdErrorDictionary
//
public class WtcpChannelIdErrorDictionary //
                extends Hashtable //
                implements IWtcpReceivable
{
    public boolean isAnySuccessful()
    {
        return this.contains(WtcpErrorCode.OK);
    }

    public WtcpChannelIdErrorDictionary()
    {
    }

    public WtcpChannelIdErrorDictionary(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        short count = inputStream.readInt16();
        WtcInt32 id;
        WtcpErrorCode errorCode;
        for (int i = 0; i < count; i++)
        {
            id = WtcInt32.valueOf(inputStream.readInt32(), true);
            errorCode = new WtcpErrorCode(inputStream);
            this.put(id, errorCode);
        }
    }

    public String toString()
    {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        Enumeration ids = this.keys();
        while (ids.hasMoreElements())
        {
            WtcInt32 id = (WtcInt32) ids.nextElement();
            WtcpErrorCode errorCode = (WtcpErrorCode) this.get(id);
            sb.append("{id=").append(id).append(", error=").append(errorCode).append('}');
            if (ids.hasMoreElements())
            {
                sb.append(',');
            }
        }
        sb.append(']');
        return sb.toString();
    }
}
//
// END WtcpChannelIdErrorDictionary
//
