package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

//
// BEGIN WtcpCallOffer
//
public class WtcpCallOffer //
                implements IWtcpReceivable
{
    public int    callId;
    public String fromNumber;
    public String fromName;
    public String toNumber;

    public WtcpCallOffer(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        fromNumber = inputStream.readString();
        fromName = inputStream.readString();
        toNumber = inputStream.readString();
    }

    public String toString()
    {
        return new StringBuffer() //
        .append("callId=").append(callId) //
        .append(", fromNumber=").append(WtcString.quote(fromNumber)) //
        .append(", fromName=").append(WtcString.quote(fromName)) //
        .append(", toNumber=").append(WtcString.quote(toNumber)) //
        .toString();
    }
}
//
// END WtcpCallOffer
//
