package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;

//
// BEGIN WtcpCallInfo
//
public class WtcpCallInfo //
                implements IWtcpReceivable
{
    public int           callId;
    public String        remoteNumber;
    public WtcpErrorCode errorCode;

    public WtcpCallInfo(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        remoteNumber = inputStream.readString();
        errorCode = new WtcpErrorCode(inputStream);
    }

    public String toString()
    {
        return new StringBuffer() //
        .append("callId=").append(callId) //
        .append(", remoteNumber=").append(remoteNumber) //
        .append(", errorCode=").append(errorCode) //
        .toString();
    }
}
//
// END WtcpCallInfo
//
