package com.twistpair.wave.thinclient.protocol.types;

import com.twistpair.wave.thinclient.util.IWtcMemoryStream;
import com.twistpair.wave.thinclient.util.WtcString;

//
// BEGIN WtcpCallDtmf
//
public class WtcpCallDtmf //
                implements IWtcpReceivable
{
    public int    callId;
    public String digits;

    public WtcpCallDtmf(IWtcMemoryStream inputStream)
    {
        loadNetworkToHostOrder(inputStream);
    }

    public void loadNetworkToHostOrder(IWtcMemoryStream inputStream)
    {
        callId = inputStream.readInt32();
        digits = inputStream.readString();
    }

    public String toString()
    {
        return new StringBuffer() //
        .append('{') //
        .append("callId=").append(callId) //
        .append(", digits=").append(WtcString.quote(digits)) //
        .append('}') //
        .toString();
    }
}
//
// END WtcpCallDtmf
//
